/*
 * Java
 *
 * Copyright 2008-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf.elflw;

import ej.annotation.Nullable;

/**
 * The symbol table section.
 */
public class SymbolTableSection extends Section {

	public byte[] data;
	@Nullable
	public StringSection stringSection;

	public SymbolTableSection(byte[] data) {
		this.data = data;
	}

	@Override
	public int size() {
		return this.data.length;
	}

	public int entrySize() {
		return ElfConstants.SYMBOL_TABLE_ENTRY_SIZE;
	}

	public int nbEntries() {
		return this.data.length / entrySize();
	}
}
