/*
 * Java
 *
 * Copyright 2008-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf.elflw;

/**
 * Symbol entry in a symbol table section
 */
public class SymbolTableEntry implements ElfConstants {

	/**
	 * The symbol name
	 */
	public byte[] name;

	/**
	 * The symbol value. When {@link #sectionIndex} != {@link ElfConstants#SHN_UNDEF} value is the offset from the
	 * beginning of the target section section.<br>
	 * Otherwise it is the absolute value of the symbol.
	 */
	public int value;

	/**
	 * The target section index, or {@link ElfConstants#SHN_UNDEF} or {@link ElfConstants#SHN_ABS}.
	 */
	public int sectionIndex;

	public SymbolTableEntry(byte[] name, int value, int sectionIndex) {
		this.name = name;
		this.value = value;
		this.sectionIndex = sectionIndex;
	}

	public boolean isAbsolute() {
		return this.sectionIndex == SHN_ABS;
	}

	public boolean isUndefined() {
		return this.sectionIndex == SHN_UNDEF;
	}
}
