/*
 * Java
 *
 * Copyright 2008-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf.elflw;

import ej.annotation.Nullable;

/**
 * ELF section header.
 */
public class SectionHeader {

	/**
	 * Section type : section's content and semantics.
	 */
	public int type;

	/**
	 * Section flags.
	 */
	public int flags; // flags

	/**
	 * The byte offset from the beginning of the file to first byte of the section.
	 */
	public int offset;

	/**
	 * Section's size in bytes.
	 */
	public int size;

	/**
	 * Holds a section header table index, depends on the section type.
	 */
	public int link;

	/**
	 * Holds extra information, depends on the section type.
	 */
	public int info;

	/**
	 * Some sections have address alignment constraints. For example, if a section holds a doubleword, the system must
	 * ensure doubleword alignment for the entire section. That is, the value of sh_addr must be congruent to 0, modulo
	 * the value of sh_addralign. Currently, only 0 and positive integral powers of two are allowed. Values 0 and 1 mean
	 * the section has no alignment constraints.
	 */
	public int addralign;

	/**
	 * Some sections hold a table of fixed-size entries, such as a symbol table. For such a section, this member gives
	 * the size in bytes of each entry. The member contains 0 if the section does not hold a table of fixed-size
	 * entries.
	 */
	public int entsize;

	/**
	 * The section content, or <code>null</code> until it is processed or if it is not kept in memory.
	 */
	@Nullable
	public Section section;
}
