/*
 * Java
 *
 * Copyright 2008-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf.elflw;

/**
 * ELF format known constants (32 bits).
 */
public interface ElfConstants {

	int HEADER_SIZE = 52;
	int SECTION_HEADER_SIZE = 40;
	int SYMBOL_TABLE_ENTRY_SIZE = 16;

	// --- Object Header

	int EI_MAG0 = 0;
	int EI_MAG1 = 1;
	int EI_MAG2 = 2;
	int EI_MAG3 = 3;

	int SIGNATURE_LENGTH = 4;

	int ELFMAG0 = (byte) 0x7F;
	int ELFMAG1 = (byte) 'E';
	int ELFMAG2 = (byte) 'L';
	int ELFMAG3 = (byte) 'F';

	int EI_CLASS = 4;
	int EI_DATA = 5;
	int EI_VERSION = 6;
	int EI_OSABI = 7;
	int EI_ABIVERSION = 8;
	int EI_NIDENT = 16;

	int ELFCLASS32 = 1;

	int ELFDATA2LSB = 1;
	int ELFDATA2MSB = 2;

	int ET_REL = 1;

	int EV_CURRENT = 1;

	// --- Sections

	int SHN_UNDEF = 0;
	int SHN_ABS = 0xFFF1;
	int SHN_XINDEX = 0xFFFF;

	int SHT_PROGBITS = 1;
	int SHT_SYMTAB = 2;
	int SHT_STRTAB = 3;
	int SHT_RELA = 4;
	int SHT_NOBITS = 8;
	int SHT_REL = 9;
	int SHT_LOPROC = 0x70000000;

	int SHF_ALLOC = 0x2;

}
