/*
 * Java
 *
 * Copyright 2015-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

public interface MemoryBlock {

	/**
	 * Get the size in bytes.
	 *
	 * @return the size in bytes.
	 */
	public int getSize();

	/**
	 * Copy bytes from the given bytes array to the chunk of memory.
	 *
	 * @param src
	 *            the source bytes array
	 * @param srcOffset
	 *            the offset in the source array
	 * @param dstOffset
	 *            the offset in the destination memory
	 * @param length
	 *            the number of bytes to copy
	 * @return <code>true</code> on success, <code>false</code> if the number of bytes is greater than the size of the
	 *         block
	 */
	public boolean copyByteArrayToMemory(byte[] src, int srcOffset, int dstOffset, int length);

	/**
	 * Copy bytes from the chunk of memory to the given bytes array.
	 *
	 * @param srcOffset
	 *            the offset in the source memory
	 * @param dst
	 *            the destination bytes array
	 * @param dstOffset
	 *            the offset in the destination array
	 * @param length
	 *            the number of bytes to copy
	 */
	public void copyMemoryToByteArray(int srcOffset, byte[] dst, int dstOffset, int length);

	public long getAddress();

}
