/*
 * Java
 *
 * Copyright 2008-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;

import java.util.Date;

/**
 * The <code>System</code> class offers basic services for BON implementation.
 */
public class Util {

	/**
	 * Tells if the system has entered the mission phase, i.e. it is initialized.<br>
	 *
	 * @see Immortals
	 * @return <code>true</code> if the initialization is done.
	 */
	public static boolean isInMission() {
		return !isInInitialization();
	}

	/**
	 * Tells if the current code is part of the initialization phase.<br>
	 * When <code>Class.forName(...)</code> triggers classes to be loaded at runtime dynamically, classes initializations are done in a context where <code>isInInitialization</code> is
	 * <code>true</code> and <code>isInMission</code> is <code>true</code>.
	 *
	 * @see Immortals
	 * @return <code>true</code> if the initialization is ongoing.
	 */
	public native static boolean isInInitialization();


	/**
	 * Deprecated: Please consider Kernel and Features specification instead.
	 * <p>
	 * Tests the ability of the system to download code through <code>Class.forName(...)</code>
	 * @return true if the system allows dynamic code to be loaded
	 */
	@Deprecated
	public static boolean dynamicCodeAllowed(){
		return false;
	}

	/**
	 * Deprecated: Please consider Kernel and Features specification instead.
	 * <p>
	 * Returns the amount of dynamic code memory used by the system.
	 */
	@Deprecated
	public static int dynamicCodeMemory(){
		return 0;
	}

	/**
	 * Deprecated: Please consider Kernel and Features specification instead.
	 * <p>
	 * Returns the amount of free dynamic code memory.
	 */
	@Deprecated
	public static int dynamicCodeFreeMemory(){
		return 0;
	}

	/**
	 * Deprecated: Please consider Kernel and Features specification instead.
	 * <p>
	 * Throw the exception in the thread. If the thread is sleeping or waiting,
	 * it is interrupted, but the exception is the specified runtime exception
	 * instead of InterruptedException. If the thread is running, the exception
	 * is thrown just like if a throw statement was the next instruction to execute.
	 * If <code>t</code> is not started yet or is terminated, nothing is done.
	 * If at least one of the argument is <code>null</code>, an <code>IllegalArgumentException</code>
	 * is thrown.
	 *
	 * @param e the exception to throw
	 * @param t the thread in which the exception is thrown
	 * @throws IllegalArgumentException if at least one of the argument is <code>null</code>.
	 */
	@Deprecated
	public static void throwExceptionInThread(RuntimeException e, Thread t){
		throwExceptionInThread(e, t, false);
	}


	/**
	 * Deprecated: Please consider Kernel and Features specification instead.
	 * <p>
	 * Throws an exception in a specified thread.<br>
	 * <ul>
	 * <li>If the thread is either sleeping or waiting, the thread is unblocked and the exception is
	 * thrown as soon as possible.</li>
	 * <li>If the thread is running, the exception is thrown just as if a throw statement was the
	 * next instruction to execute.</li>
	 * <li>If the thread is not started yet or is terminated, nothing is done.</li>
	 * <li>If the thread has entered one or more critical sections, it does not wait the critical
	 * sections to finish and the exception is thrown as soon as possible.</li>
	 * </ul>
	 * <br>
	 *
	 * @param e
	 *            the exception to throw
	 * @param t
	 *            the thread in which the exception is thrown
	 * @throws IllegalArgumentException
	 *             if any of the arguments is <code>null</code>.
	 */
	@Deprecated
	public static void throwHardExceptionInThread(RuntimeException e, Thread t) {
		throwExceptionInThread(e, t, true);
	}

	/**
	 * <p>
	 * Gets the application time in milliseconds.
	 * </p>
	 * <p>
	 * The result of this method is the same as the {@link System#currentTimeMillis()} method one.
	 * </p>
	 *
	 * @return the application time in milliseconds
	 */
	public static long currentTimeMillis(){
		return System.currentTimeMillis();
	}

	/**
	 * <p>
	 * Gets the platform time in millisecond.
	 * </p>
	 * <p>
	 * The platform time is the running time since the start of the device. This time is independent from any user considerations
	 * and cannot be changed.
	 * </p>
	 *
	 * @return the platform time in milliseconds
	 */
	public static long platformTimeMillis(){
		return CurrentTime.get(true);
	}

	/**
	 * <p>
	 * Gets the platform time in nanoseconds.
	 * </p>
	 * <p>
	 * The platform time is the running time since the start of the device. This time is independent from any user considerations
	 * and cannot be changed.
	 * </p>
	 *
	 * @return the platform time in nanoseconds
	 */
	public static long platformTimeNanos(){
		return CurrentTime.getNanos();
	}


	/**
	 * <p>
	 * Sets the application time.
	 * </p>
	 * <p>
	 * This time does not change the platform time.
	 * </p>
	 *
	 * @param t the application time to set in milliseconds
	 *
	 * @throws IllegalArgumentException if <code>t</code> is negative
	 */
	public static void setCurrentTimeMillis(long t){
		CurrentTime.setAppTime(t);
	}

	/**
	 * <p>
	 * Sets the application time.
	 * </p>
	 * <p>
	 * This time does not change the platform time.
	 * The result of this method is the same as the <code>Util.setCurrentTimeMillis(d.getTime())</code> method one.
	 * </p>
	 *
	 * @param d the application time to set
	 */
	public static void setCurrentTimeMillis(Date d){
		CurrentTime.setAppTime(d.getTime());
	}

	native private static void throwExceptionInThread(RuntimeException e, Thread t, boolean hard);

	public static native <T> T[] newArray(Class<T[]> type, int length);
}