/**
 * Java
 *
 * Copyright 2008-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;

import ej.annotation.Nullable;

/**
 * ReferenceQueue represents a queue of EnqueuedWeakReference. The system is responsible for adding such EnqueuedWeakReference into ReferenceQueue.<br>
 * There are two way to query the queue in order to check and remove if a Reference has been added to the queue.<br>
 * - <code>poll</code> : returns null if the queue is empty, otherwise returns and removes the first element of the FIFO queue.<br>
 * - <code>remove</code> : blocks the current thread until the queue becomes not empty. returns and removes the first element of the FIFO queue.<br>
 *
 * @see EnqueuedWeakReference
 */
public final class ReferenceQueue<T> {

	/**
	 * ReferenceQueue that is decorated by this class.
	 */
	java.lang.ref.ReferenceQueue<T> internQueue;

	/**
	 * */
	public ReferenceQueue(){
		this.internQueue = new java.lang.ref.ReferenceQueue<T>();
	}

	/**
	 * Queries the queue and returns and removes the first element of the queue.
	 * If the queue is empty, returns <code>null</code>.
	 * @return EnqueuedWeakReference or <code>null</code>
	 */
	@Nullable
	public EnqueuedWeakReference<T> poll() {
		return (EnqueuedWeakReference<T>) this.internQueue.poll();
	}

	/**
	 * Queries the queue, returns and removes the first element of the queue.
	 * If the queue is empty, blocks the current thread until the queue gets
	 * at least one element (automatically added by the system).
	 * @return EnqueuedWeakReference
	 * @throws InterruptedException if the thread is interrupted
	 */
	public EnqueuedWeakReference<T> remove() throws InterruptedException {
		return (EnqueuedWeakReference<T>) this.internQueue.remove();
	}

}