/**
 * Java
 *
 * Copyright 2008-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;

import java.lang.ref.WeakReference;

import ej.annotation.Nullable;

/**
 * EnqueuedWeakReference are objects that are queued in an ReferenceQueue
 * by the system when the object they point at (see <code>get()</code>) is set to <code>null</code>
 * by the system. A typical use is to subclass <code>EnqueuedWeakReference</code>
 * with classes that hold native handles that need to be freed at the native level.
 * */
public class EnqueuedWeakReference<T> extends WeakReference<T> {

	/**
	 * @param ref : the object the reference points at. It becomes <code>null</code>
	 * automatically when no reference points at ref (except WeakReference).
	 * @param queue : the ReferenceQueue the reference is add to when the object
	 * it points at becomes <code>null</code>.
	 */
	public EnqueuedWeakReference(T ref, @Nullable ReferenceQueue<T> queue) {
		super(ref, queue!=null ? queue.internQueue : null);
	}
}