/**
 * Java
 *
 * Copyright 2010-2012 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;


public class CurrentTime {

	/**
	 * Gets the system or the application time.
	 *
	 * @see #get()
	 * @see #getAppTime()
	 * @param system
	 *            <code>true</code> to get the system time, <code>false</code> to get the application time
	 * @return the system or application time
	 */
	public static native long get(boolean system);

	/**
	 * Gets the system time in nanos.
	 *
	 * @see #get()
	 * @return the system time in nanos
	 */
	public static native long getNanos();
	
	/**
	 * CT-API Sets the application time. This time does not change the system time.
	 * 
	 * @param t
	 *            the time to set
	 */
	public static void setAppTime(long t) {
		if (t < 0) {
			throw new IllegalArgumentException();
		}
		set(t);
	}
	public static native void set(long t) ;


}
