/*
 * Java
 *
 * Copyright 2011-2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;

public class ByteArray {

	public static final int BYTE_SIZE = 1;

	public static final int CHAR_SIZE = 2;

	public static final int SHORT_SIZE = 2;

	public static final int INT_SIZE = 4;

	public static final int LONG_SIZE = 8;

	/**
	 * Access mode little endian.
	 */
	public static final int LITTLE_ENDIAN = 0;

	/**
	 * Access mode big endian.
	 */
	public static final int BIG_ENDIAN = 1;

	/**
	 * <p>
	 * Gets whether the platform is in big endian or little endian.
	 * </p>
	 *
	 * @return {@link #BIG_ENDIAN} if the platform is in big endian, {@link #LITTLE_ENDIAN} if in little endian
	 */
	public static int getPlatformEndianness(){
		return isBigEndian() ? BIG_ENDIAN : LITTLE_ENDIAN;
	}

	native public static boolean isBigEndian();

	native public static int readUnsignedByte(byte[] array, int offset);

	native public static short readShort(byte[] array, int offset);

	native public static char readChar(byte[] array, int offset);

	native public static int readInt(byte[] array, int offset);

	native public static long readLong(byte[] array, int offset);

	native public static short readShort(byte[] array, int offset, int endianness);

	native public static char readChar(byte[] array, int offset, int endianness);

	native public static int readInt(byte[] array, int offset, int endianness);

	native public static long readLong(byte[] array, int offset, int endianness);

	native public static void writeShort(byte[] array, int offset, int value);

	native public static void writeInt(byte[] array, int offset, int value);

	native public static void writeLong(byte[] array, int offset, long value);

	native public static void writeShort(byte[] array, int offset, int value, int endianness);

	native public static void writeInt(byte[] array, int offset, int value, int endianness);

	native public static void writeLong(byte[] array, int offset, long value, int endianness);

	native public static void clear(byte[] array, int offset, int length);

	native public static void set(byte[] array, byte value, int offset, int length);

}
