/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.bon.timer;

import ej.bon.TimerTask;

/**
 * Reference to the application {@link TimerTask}. 2 {@link TimerTask} cannot be
 * linked together in case of KF support.
 */
public class TimerTaskRef {

	// next in the linked list of task
	public TimerTaskRef next;

	/*
	 * package private field Both {@link TimerTaskList} & {@link TimerTaskRef} are
	 * extracted in a separate package. This ensures that {@link Timer} code does
	 * not directly touch a {@link TimerTask} reference. This is mandatory to avoid
	 * Kernel stale references in {@link Timer#run()} when a {@link Feature} is
	 * stopped.
	 */
	TimerTask task;

	public TimerTaskRef(TimerTask task) {
		this.task = task;
	}

	/**
	 * @return {@link TimerTask#absoluteTime}
	 */
	public long getAbsoluteTime() {
		// extracted access to TimerTask
		return task.absoluteTime;
	}
}
