/*
 * Java
 *
 * Copyright 2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.bon;

/**
 * This exception is thrown by the Simulator when a constant could not be
 * loaded. This class is not touched by the rest of the code.
 */
@SuppressWarnings("serial")
public class InvalidConstantError extends Error {

	/*
	 * Well known constant by the native side
	 */
	private static final int ERROR_NPE = 1;

	/*
	 * Well known constant by the native side
	 */
	private static final int ERROR_NOT_A_STRING_LITERAL = 2;

	/*
	 * Well known constant by the native side
	 */
	private static final int ERROR_UNDEFINED_CONSTANT = 3;

	/*
	 * Well known constant by the native side
	 */
	private static final int ERROR_UNDEFINED_CONSTANT_BOOLEAN = 4;

	/*
	 * Well known constant by the native side
	 */
	public static final int ERROR_UNDEFINED_CONSTANT_BYTE = 5;

	/*
	 * Well known constant by the native side
	 */
	public static final int ERROR_UNDEFINED_CONSTANT_CHAR = 6;

	/*
	 * Well known constant by the native side
	 */
	public static final int ERROR_UNDEFINED_CONSTANT_SHORT = 7;

	/*
	 * Well known constant by the native side
	 */
	public static final int ERROR_UNDEFINED_CONSTANT_INT = 8;

	/*
	 * Well known constant by the native side
	 */
	public static final int ERROR_UNDEFINED_CONSTANT_FLOAT = 9;

	/*
	 * Well known constant by the native side
	 */
	public static final int ERROR_UNDEFINED_CONSTANT_LONG = 10;

	/*
	 * Well known constant by the native side
	 */
	public static final int ERROR_UNDEFINED_CONSTANT_DOUBLE = 11;

	/*
	 * Well known constant by the native side
	 */
	public static final int ERROR_UNDEFINED_CONSTANT_CLASS = 12;

	/*
	 * Well known field by the native side. May be null depending on the error.
	 */
	private int errorCode;

	/*
	 * Well known field by the native side. May be null depending on the error.
	 */
	private String name;

	/*
	 * Well known field by the native side. May be null depending on the error.
	 */
	private String value;

	/**
	 * Creates a new {@link InvalidConstantError}. The an error code and the name
	 * and the value are filled by the native side
	 */
	public InvalidConstantError() {
	}

	@Override
	public String getMessage() {
		switch (errorCode) {
		case ERROR_NPE:{
			return "Constant name is a not a String Literal (null)";
		}
		case ERROR_NOT_A_STRING_LITERAL: {
			return "Constant name is a not a String Literal (not a constant)";
		}
		case ERROR_UNDEFINED_CONSTANT: {
			return "Constant '" + name + "' is undefined";
		}
		case ERROR_UNDEFINED_CONSTANT_BOOLEAN: {
			return "Constant '" + name + "' cannot be resolved to a boolean (value is '" + value + "')";
		}
		case ERROR_UNDEFINED_CONSTANT_BYTE: {
			return "Constant '" + name + "' cannot be resolved to a byte (value is '" + value + "')";
		}
		case ERROR_UNDEFINED_CONSTANT_CHAR: {
			return "Constant '" + name + "' cannot be resolved to a char (value is '" + value + "')";
		}
		case ERROR_UNDEFINED_CONSTANT_SHORT: {
			return "Constant '" + name + "' cannot be resolved to a short (value is '" + value + "')";
		}
		case ERROR_UNDEFINED_CONSTANT_INT: {
			return "Constant '" + name + "' cannot be resolved to an int (value is '" + value + "')";
		}
		case ERROR_UNDEFINED_CONSTANT_FLOAT: {
			return "Constant '" + name + "' cannot be resolved to a float (value is '" + value + "')";
		}
		case ERROR_UNDEFINED_CONSTANT_LONG: {
			return "Constant '" + name + "' cannot be resolved to a long (value is '" + value + "')";
		}
		case ERROR_UNDEFINED_CONSTANT_DOUBLE: {
			return "Constant '" + name + "' cannot be resolved to a double (value is '" + value + "')";
		}
		case ERROR_UNDEFINED_CONSTANT_CLASS: {
			return "Constant '" + name + "' cannot be resolved to a class (value is '" + value + "')";
		}
		default:{
			// unknown error code
			return "E=" + errorCode + "(" + name + "=" + value + ")";
		}
		}
	}
}
