/**
 * Java
 *
 * Copyright 2014 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.bon;

public class ImmutablesNatives {

	/**
	 * Implementation note: Do not cache the result.
	 * May return a different value depending on context owner
	 */
	public static native int getNbImmutableKeys();
	
	/**
	 * @param array assume its length is > {@link #getNbImmutableKeys()}
	 */
	public static native void fillImmutableKeys(String[] array);
	
	/**
	 * @return the immutable object (may be null)  associated to the given key.
	 * @throw {@link IndexOutOfBoundsException} if no immutable found with the given key
	 */
	public static native Object get(String id);

	/** Returns the amount of initial immutable memory used by the system. */
	public native static long initialImmutableMemory();

	/**
	 * @param o : the queried object
	 * @return <code>true</code> if the queried object is immutable,
	 * <code>false</code> otherwise.
	 * @throws NullPointerException if given object is null
	 */
	public native static boolean isImmutable(Object o);

}
