/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.bon;

import com.is2t.bon.BONFactory;
import com.is2t.bon.timer.TimerTaskList;
import com.is2t.bon.timer.TimerTaskListKernel;

import ej.kf.Kernel;

public class BONFactoryKF extends BONFactory {

	/**
	 * Kernel lazy initialization method for {@link BONFactory#INSTANCE}
	 */
	public static BONFactory createFactory() {
		if (Kernel.isInKernelMode()) {
			return new BONFactoryKF();
		} else {
			Kernel.enter();
			return BONFactory.getInstance();
		}
	}

	public TimerTaskList newTimerTaskList() {
		if (Kernel.isInKernelMode()) {
			// Implementation that allow TimerTasks owned by Features
			return new TimerTaskListKernel();
		}
		else {
			// Default implementation.
			return super.newTimerTaskList();
		}
	}
}
