/*
 * Java
 *
 * Copyright 2008-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.util;

import ej.annotation.NonNullByDefault;

@NonNullByDefault(Iterable.DISABLE_NULL_ANALYSIS_COLLECTIONS)
public class Stack<E> extends Vector<E> {

	public Stack() {
		super();
	}

	public boolean empty() {
		return super.isEmpty();
	}

	public synchronized E peek() {
		try {
    		@SuppressWarnings("unchecked")
			E result = (E) this.elementData[this.elementCount-1]; // cast is safe
    		return result;
    	}
    	catch(ArrayIndexOutOfBoundsException e) {
    		// Stack is empty
    		throw new EmptyStackException();
    	}
	}

	public synchronized E pop() {
		try {
			@SuppressWarnings("unchecked")
			E element = (E) this.elementData[--this.elementCount]; // cast is safe
			this.elementData[this.elementCount] = null; //unlink element
			return element;
		} catch (ArrayIndexOutOfBoundsException e) {
			// Stack was empty, reincrement size (= 0)
			elementCount++;
			throw new EmptyStackException();
		}
	}

	public E push(E item) {
		super.addElement(item);
		return item;
	}

	public synchronized int search(Object o) {
    	int i = this.elementCount;
    	//search o in the stack from the top
    	while(--i >= 0)
    	{
    		Object obj = this.elementData[i];
    		if(obj != null && obj.equals(o)) {
    			return this.elementCount - i;	
    		}
    	}
    	return -1;
	}
}