/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.util;

import java.security.BasicPermission;

import ej.annotation.Nullable;

@SuppressWarnings("serial")
public final class PropertyPermission extends BasicPermission {

	// Implementation notes:
	// read/write strings are not embedded if user does not care about property permissions
	
	public static final String ACTION_READ_STR = "read"; //$NON-NLS-1$
	public static final String ACTION_WRITE_STR = "write"; //$NON-NLS-1$
	public static final int ACTION_READ = 1<<0;
	public static final int ACTION_WRITE = 1<<1;
	private int actions;
	
	public PropertyPermission(String name, String actions) {
		super(name, actions);
		int start = 0;
		int commaIndex;
		while(true){
			commaIndex = actions.indexOf(',', start);
			if(commaIndex == -1)
				break;
			addAction(actions, start, commaIndex);
			start = commaIndex+1;
		}
		if(start < actions.length)
			addAction(actions, start, actions.length);
		if(this.actions == 0)
			throw new IllegalArgumentException(); // at least one action need to be set
	}
	
	private void addAction(String actions, int start, int commaIndex) {
		String action = actions.substring(start, commaIndex);
		if(action.equals(ACTION_READ_STR))
			this.actions |= ACTION_READ;
		else if(action.equals(ACTION_WRITE_STR))
			this.actions |= ACTION_WRITE;
		else
			throw new IllegalArgumentException(action);
	}

	// used by System.getProperty()
	public PropertyPermission(String name, int actions) {
		super(name);
		this.actions = actions;	
	}

	public boolean equals(@Nullable Object obj) {
		if(obj instanceof PropertyPermission) {
			return super.equals(obj) && actions == ((PropertyPermission)obj).actions;
		}
		else {
			return false;
		}
	}

	public String getActions() {
		StringBuilder sb = new StringBuilder();
		boolean append = false;
		if((actions & ACTION_READ) != 0){
			sb.append("read"); //$NON-NLS-1$
			append = true;
		}
		if((actions & ACTION_WRITE) != 0){
			if(append)
				sb.append(',');
			sb.append("write"); //$NON-NLS-1$
		}
		return sb.toString();
	}

}