/*
 * Java
 *
 * Copyright 2013-2020 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.util;

import ej.annotation.NonNullByDefault;
import ej.annotation.Nullable;

@NonNullByDefault(Iterable.DISABLE_NULL_ANALYSIS_COLLECTIONS)
public interface Map<K, V> {

	@NonNullByDefault(Iterable.DISABLE_NULL_ANALYSIS_COLLECTIONS)
	interface Entry<K, V> {

		boolean equals(@Nullable Object o);
		
		K getKey();

		V getValue();

		int hashCode();

		V setValue(V value);
	}

	void clear();

	boolean containsKey(Object key);

	boolean containsValue(Object value);

	Set<Map.Entry<K, V>> entrySet();

	boolean equals(@Nullable Object o);
	
	@Nullable 
	V get(Object key);

	int hashCode();

	boolean isEmpty();

	Set<K> keySet();

	@Nullable 
	V put(K key, V value);

	void putAll(Map<? extends K, ? extends V> m);

	@Nullable 
	V remove(Object key);

	int size();

	Collection<V> values();
}
