/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.util;

import ej.annotation.NonNullByDefault;

@NonNullByDefault(Iterable.DISABLE_NULL_ANALYSIS_COLLECTIONS)
public class HashMap<K, V> extends AbstractHashMap<K, V> {
	
	@NonNullByDefault(Iterable.DISABLE_NULL_ANALYSIS_COLLECTIONS)
	protected static class HashMapEntry<K, V> extends AbstractHashMapEntry<K, V> {
		
		K key;
		
		public HashMapEntry(K key, V value, AbstractHashMapEntry<K, V> next) {
			super(value, next);			
			this.key = key;
		}

		@Override
		public K getKey() {
			return key;
		}
	}

	public HashMap() {
		super();
	}

	public HashMap(int initialCapacity) {
		super(initialCapacity);
	}

	public HashMap(int initialCapacity, float loadFactor) {
		super(initialCapacity, loadFactor);
	}

	public HashMap(Map<? extends K, ? extends V> m) {
		super(m);
	}

	// AbstractHashMap implements Cloneable
	// Sonar does not seem to handle this fact
	@Override
	@SuppressWarnings("unchecked")
	public Object clone() { //NOSONAR
		try {
			HashMap<K, V> clone = (HashMap<K, V>) super.clone();
			clone.modCount = 0; // modCount must not be cloned!
			clone.keys = null;
			clone.values = null;
			
			//clone entries
			AbstractHashMapEntry<K, V>[] thisBuckets = this.buckets;
			HashMapEntry<K, V>[] cloneBuckets = new HashMapEntry[thisBuckets.length];
			clone.buckets = cloneBuckets;
			AbstractHashMap.cloneEntries(thisBuckets, cloneBuckets);
			return clone;
		} catch (CloneNotSupportedException e) {
			// Should not happen since HashMap implements Cloneable
			throw new InternalError(); //NOSONAR
		}
	}

	@Override
	protected java.util.AbstractHashMap.AbstractHashMapEntry<K, V> newHashEntry(K key, V value, java.util.AbstractHashMap.AbstractHashMapEntry<K, V> next) {
		return new HashMapEntry<K, V>(key, value, next);
	}

}
