/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */ 
package java.util;

import ej.annotation.NonNullByDefault;
import ej.annotation.Nullable;

@NonNullByDefault(Iterable.DISABLE_NULL_ANALYSIS_COLLECTIONS)
public interface Collection<E> extends Iterable<E> {

	boolean add(E e);

	boolean addAll(Collection<? extends E> c);

	void clear();

	boolean contains(Object o);

	boolean containsAll(Collection<?> c);

	boolean equals(@Nullable Object o);

	int hashCode();

	boolean isEmpty();

	
	Iterator<E> iterator();

	boolean remove(Object o);

	boolean removeAll(Collection<?> c);

	boolean retainAll(Collection<?> c);

	int size();

	
	Object[] toArray();

	
	<T> T[] toArray(T[] a);
}
