/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.security;

import ej.annotation.Nullable;

@SuppressWarnings("serial")
public abstract class Permission implements Guard, java.io.Serializable {

	protected String name;
	
	public Permission(String name) {
		this.name = name;
	}

	@Override
	public abstract boolean equals(@Nullable Object obj);

	public abstract String getActions();

	public final String getName() {
		return name;
	}

	@Override
	public abstract int hashCode();

	public abstract boolean implies(Permission permission);

	// Although not specified in the javadoc, actions may be null in subclasses (legacy Permission in other MicroEJ libraries)
	@SuppressWarnings("null")
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder()
		 .append('(').append('\"').append(getClass().getName()).append('\"').append(' ').append('\"').append(name).append('\"');
		String actions = getActions();
		if(actions != null && !actions.isEmpty()){
			sb.append(' ').append('\"').append(actions).append('\"');
		}
		sb.append(')');
		return sb.toString();
	}
}
