/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.security;

import java.io.Serializable;

import ej.annotation.Nullable;

@SuppressWarnings("serial")
public abstract class BasicPermission extends Permission implements Serializable {

	public BasicPermission(String name) {
		super(name);
		if(name.isEmpty())
			throw new IllegalArgumentException();
	}

	public BasicPermission(String name, @Nullable String actions) {
		this(name);
	}

	public boolean equals(@Nullable Object obj) {
		Class<?> objclass;
		try {
			objclass = obj.getClass();
		}
		catch(NullPointerException e) {
			return false;	
		}		
		return getClass().equals(objclass) && name.equals(((BasicPermission)obj).getName());
	}

	public String getActions() {
		return ""; //$NON-NLS-1$
	}

	public int hashCode() {
		return getName().hashCode();
	}

	public boolean implies(Permission p) {
		if(p.getClass() != getClass())
			return false;
		String name = getName(); // not empty for sure (see constructor)
		int length = name.length;
		
		if(length == 1 && name.chars[name.offset] == '*'){
			return true;
		}
		
		if(name.lastIndexOf('*') == length-1 && name.lastIndexOf('.') == length-2){
			// ends with .*
			return p.getName().startsWith(name.substring(0, length-2));
		}
		else{
			return name.equals(p.getName());
		}
	}

}
