/*
 * Java
 *
 * Copyright 2008-2019 IS2T. All rights reserved
 * IS2T PROPRIETARY/CONFIDENTIAL Use is subject to license terms.
 */
package java.lang;

import ej.annotation.Nullable;

public final class StringBuffer extends AbstractStringBuilder {

	public StringBuffer() {
		super();
	}

	public StringBuffer(CharSequence seq) {
		super(16 + seq.length());
		_append(seq);
	}

	public StringBuffer(int capacity) {
		super(capacity);
	}

	public StringBuffer(String str) {
		super(16 + str.length());
		_append(str);
	}

	public StringBuffer append(boolean b) {
		return append(Boolean.toString(b));
	}

	public synchronized StringBuffer append(char c) {
		ensureCapacity(this.length + 1);
		this.sharedCharArray[length++] = c;
		return this;
	}

	public synchronized StringBuffer append(char[] str) {
		_append(str, 0, str.length);
		return this;
	}

	public synchronized StringBuffer append(char[] str, int offset, int len) {
		_append(str, offset, len);
		return this;
	}

	public synchronized StringBuffer append(@Nullable CharSequence s) {
		_append(s);
		return this;
	}

	public synchronized StringBuffer append(@Nullable CharSequence s, int start, int end) {
		_append(s, start, end);
		return this;
	}

	public StringBuffer append(double d) {
		return append(Double.toString(d));
	}

	public StringBuffer append(float f) {
		return append(Float.toString(f));
	}

	public StringBuffer append(int i) {
		return append(Integer.toString(i));
	}

	public StringBuffer append(long lng) {
		return append(Long.toString(lng));
	}

	public StringBuffer append(@Nullable Object obj) {
		// To handle null value of obj
		return append(String.valueOf(obj));
	}

	public synchronized StringBuffer append(@Nullable String str) {
		_append(str);
		return this;
	}

	public synchronized StringBuffer append(@Nullable StringBuffer sb) {
		_append(sb);
		return this;
	}

	@Override
	public synchronized int capacity() {
		return super.capacity();
	}

	@Override
	public synchronized char charAt(int index) {
		return super.charAt(index);
	}

	public synchronized StringBuffer delete(int start, int end) {
		_delete(start, end);
		return this;
	}

	public synchronized StringBuffer deleteCharAt(int index) {
		_deleteCharAt(index);
		return this;
	}

	@Override
	public synchronized void ensureCapacity(int minimumCapacity) {
		super.ensureCapacity(minimumCapacity);
	}

	@Override
	public synchronized void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
		super.getChars(srcBegin, srcEnd, dst, dstBegin);
	}
	
	public synchronized int indexOf(String str) {
		return indexOf(str, 0);
	}

	@Override
	public synchronized int indexOf(String str, int fromIndex) {
		return super.indexOf(str, fromIndex);
	}

	public StringBuffer insert(int offset, boolean b) {
		String value = Boolean.toString(b);
		return insert(offset, value.chars, value.offset, value.length);
	}

	public StringBuffer insert(int offset, char c) {
		String value = String.valueOf(c);
		return insert(offset, value.chars, value.offset, value.length);
	}

	public StringBuffer insert(int offset, char[] str) {
		return insert(offset, str, 0, str.length);
	}

	public synchronized StringBuffer insert(int index, char[] str, int offset, int len) {
		_insert(index, str, offset, len);
		return this;
	}

	public synchronized StringBuffer insert(int dstOffset, @Nullable CharSequence s) {
		_insert(dstOffset, s);
		return this;
	}

	public synchronized StringBuffer insert(int dstOffset, @Nullable CharSequence s, int start, int end) {
		_insert(dstOffset, s, start, end);
		return this;
	}

	public StringBuffer insert(int offset, double d) {
		String value = Double.toString(d);
		return insert(offset, value.chars, value.offset, value.length);
	}

	public StringBuffer insert(int offset, float f) {
		String value = Float.toString(f);
		return insert(offset, value.chars, value.offset, value.length);
	}

	public StringBuffer insert(int offset, int i) {
		String value = Integer.toString(i);
		return insert(offset, value.chars, value.offset, value.length);
	}

	public StringBuffer insert(int offset, long l) {
		String value = Long.toString(l);
		return insert(offset, value.chars, value.offset, value.length);
	}

	public StringBuffer insert(int offset, Object obj) {
		String value = String.valueOf(obj);
		return insert(offset, value.chars, value.offset, value.length);
	}

	public synchronized StringBuffer insert(int offset, @Nullable String str) {
		_insert(offset, str);
		return this;
	}

	@Override
	public synchronized int lastIndexOf(String str, int fromIndex) {
		return super.lastIndexOf(str, fromIndex);
	}

	public synchronized StringBuffer replace(int start, int end, String str) {
		_replace(start, end, str);
		return this;
	}

	public synchronized StringBuffer reverse() {
		_reverse();
		return this;
	}

	@Override
	public synchronized void setCharAt(int index, char ch) {
		super.setCharAt(index, ch);
	}

	@Override
	public synchronized void setLength(int newLength) {
		super.setLength(newLength);
	}

	@Override
	public synchronized CharSequence subSequence(int start, int end) {
		return substring(start, end);
	}

	@Override
	public synchronized String substring(int start) {
		return substring(start, this.length);
	}

	@Override
	public synchronized String substring(int start, int end) {
		return super.substring(start, end);
	}

	@Override
	public synchronized String toString() {
		return super.toString();
	}

	@Override
	public synchronized void trimToSize() {
		super.trimToSize();
	}

	public void preInsert(int offset, int nbChars) {
		if(offset > this.length || nbChars < 0) {
			throw new IndexOutOfBoundsException() ;
		}
		
		char[] toInsert = new char[nbChars];
		this.insert(offset, toInsert);
	}
}
