/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.lang;

import java.security.Permission;

import com.is2t.vm.support.CalibrationConstants;

public class SecurityManager {

	public SecurityManager() {
		if (ej.bon.Constants.getBoolean(CalibrationConstants.CONSTANT_USE_SECURITYMANAGER)) {
			SecurityManager sm = System.getSecurityManager();
			if(sm != null){
				sm.checkPermission(new RuntimePermission("createSecurityManager")); //$NON-NLS-1$
			}
		}
	}
	
	/**
     * Throws a <code>SecurityException</code> if the
     * calling thread is not allowed to modify the thread argument.
     * <p>
     * This method is invoked for the current security manager by the
     * <code>setPriority</code> and <code>setName</code> methods of
     * class <code>Thread</code>.
     * <p>
     * If the thread argument is a system thread then
     * this method calls <code>checkPermission</code> with the
     * <code>RuntimePermission("modifyThread")</code> permission.
     * If the thread argument is <i>not</i> a system thread,
     * this method just returns silently.
     * <p>
     * Applications that want a stricter policy should override this
     * method. If this method is overridden, the method that overrides
     * it should additionally check to see if the calling thread has the
     * <code>RuntimePermission("modifyThread")</code> permission, and
     * if so, return silently. This is to ensure that code granted
     * that permission is allowed to manipulate any thread.
     * <p>
     * If this method is overridden, then
     * <code>super.checkAccess</code> should
     * be called by the first statement in the overridden method, or the
     * equivalent security check should be placed in the overridden method.
     *
     * @param      t   the thread to be checked.
     * @exception  SecurityException  if the calling thread does not have
     *             permission to modify the thread.
     * @exception  NullPointerException if the thread argument is
     *             <code>null</code>.
     * @see        java.lang.Thread#setName(java.lang.String) setName
     * @see        java.lang.Thread#setPriority(int) setPriority
     * @see        #checkPermission(java.security.Permission) checkPermission
     */
    public void checkAccess(Thread t) {
		// Java SE specification:
    	// application threads (main thread) are in the "main" ThreadGroup, which parent is the "system" ThreadGroup
    	// => In EDC, we do not have ThreadGroup notion: All threads are considered to be part of the "main" ThreadGroup.
    	// There is no need to call checkPermission(new RuntimePermission("modifyThread"). (the user may override this method)
    	// => by default, do nothing.    	
    }

	public void checkPermission(Permission perm) {
		// by default, do nothing.
	}

}
