/*
 * Java
 *
 * Copyright 2004-2021 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.lang;

import com.is2t.vm.support.CalibrationConstants;

import ej.bon.Constants;

public class Runtime extends Object {
	
	// singleton obj
	static final Runtime instance = new Runtime() ;
    private Runtime(){}

    public void exit(int status){
		if (Constants.getBoolean(CalibrationConstants.CONSTANT_USE_SECURITYMANAGER)) {
	    	SecurityManager securityManager = System.getSecurityManager();
	    	if (securityManager != null) {
	    		securityManager.checkPermission(new RuntimePermission("exitVM."+status)); //$NON-NLS-1$
	    	}
		}
		exit0(status);
	}
    
	public native void exit0(int status);
//    {
//        //creating a new thread permits to the current thread to be killed normally
//        Thread threadsKiller = new Thread(new ThreadsKiller());
//        threadsKiller.setPriority(Thread.MAX_PRIORITY);
//        threadsKiller.start();
//
//        while(true);//wait for the threads killer to stop me
//    }

	public native long freeMemory() ;

	public native void gc() ;

	public static Runtime getRuntime() {
		return Runtime.instance ;
	}
	
	public native long totalMemory() ;
	
	/**
	 * Returns the maximum amount of memory that the Java virtual machine will attempt to use. If
	 * there is no inherent limit then the value {@link java.lang.Long#MAX_VALUE} will be returned.
	 * </p>
	 * 
	 * @return the maximum amount of memory that the virtual machine will attempt to use, measured
	 *         in bytes
	 */
	public native long maxMemory();
}
