/*
 * Java
 *
 * Copyright 2004-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.lang;

import ej.annotation.Nullable;

//note : most API comments are come from
//       the CLDC 1.1 specification

public class Object {
	
	public Object() {
	    //Do not add any code here : it is assumed to be empty.
    }
	
	// Object does not implement Cloneable
	protected Object clone() throws CloneNotSupportedException { //NOSONAR
		if(this instanceof Cloneable || this.getClass().isArray()) {
			return this.cloneNative();
		}
		
		throw new CloneNotSupportedException();
	}
	
	private final native Object cloneNative();

	public boolean equals (@Nullable Object obj) {
		return obj == this ;
	}

	public final native Class<?> getClass() ;			// May throw SecurityException (for OSGi "bundle-private" class access)
	public final native Class<?> originalGetClass() ;	// standard getClass()
	
	public int hashCode(){
        return System.hashCode(this);
    }

	public final void notify() {
		notify(false);
	}

	public final void notifyAll(){
		notify(true);
	}
	
	private final native void notify(boolean all);
	
	public String toString() {
		return new StringBuilder(originalGetClass().getName())
		  .append('@')
		  .append(Integer.toHexString(hashCode()))
		  .toString();
	}

	public final void wait() throws InterruptedException {
		wait(0) ;
	}
	
	//VM/Soar Known : converted in opcode
	// not allow in ACID transaction context
	public final native void wait(long timeout) throws InterruptedException;

	public final void wait(long timeout, int nanos) throws InterruptedException {
		//
		// Note : 0 < nanos < 999.999
		//
		// If the amount of nanoseconds is less than 500.000, so we simply
		// call the wait(timeout) unless timeout is equal to zero.
		//
		// If the amout is greater than 500000 (ie. 0,5ms) we increase the timeout
		// by 1 and then call the wait(timeout) method.
		
		if (nanos >= 0 && nanos <= 999999 && timeout>=0) {
			if (nanos < 500000) {
				if (timeout == 0 && nanos != 0){
					wait(1) ;
				}else{
					wait(timeout) ;
				}
			} else{
				wait(timeout+1) ;
			}
		} else {
			throw new IllegalArgumentException();
		}
	}

}

