/*
 * Java
 * 
 * Copyright 2008-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.lang;

import ej.annotation.Nullable;

public final class Byte extends Number implements Comparable<Byte> {
	
	/* CLASS CONSTANTS */
	public static final byte MAX_VALUE = 127;
	public static final byte MIN_VALUE = -128;
	public static final int SIZE = 8;
	
	/* INSTANCE VARIABLES */
	private byte value ;
	
	public static int compare(byte x, byte y) {
		return x - y;
	}
	
	public static Byte decode(String nm) throws NumberFormatException {
		// Steps: 
		// - decode as an integer
		// - check bounds
		
		// step 1
		int decode = Integer.decode(nm).intValue();
		
		// step 2
		if(decode > MAX_VALUE || decode < MIN_VALUE) {
			throw new NumberFormatException();
		}
		
		return valueOf((byte) decode); // cast is safe
	}
	
	public static byte parseByte(String s) throws NumberFormatException {
		return parseByte(s, 10);
	}
	
	public static byte parseByte(String s, int radix) throws NumberFormatException {
		// Steps: 
		// - parse as an integer
		// - check bounds
		
		// step 1
		int parse = Integer.parseInt(s, radix) ;
		
		// step 2
		if(parse > MAX_VALUE || parse < MIN_VALUE) {
			throw new NumberFormatException();
		}
		
		return (byte) parse; // cast is safe
	}
	
	public static String toString(byte b) {
		// As always, use Integer methods
		return Integer.toString(b);
	}
	
	public static Byte valueOf(byte b) {
		return new Byte(b);
	}
	
	public static Byte valueOf(String s) throws NumberFormatException {
		return valueOf(s, 10);
	}
	
	public static Byte valueOf(String s, int radix) throws NumberFormatException {
		return valueOf(parseByte(s, radix));
	}
	
	public Byte(byte value) {
		this.value = value ;
	}
	
	public Byte(String s) throws NumberFormatException {
		this(parseByte(s, 10));
	}

	public byte byteValue() {
		return this.value ;
	}
	
	public int compareTo(Byte anotherByte) {
		return compare(this.value, anotherByte.value);
	}
	
	public double doubleValue() {
		return (double) this.value;
	}

	public boolean equals(@Nullable Object obj) {
		try {
			return ((Byte)obj).value == this.value ;
		}
		catch (ClassCastException | NullPointerException e){
			// obj is not a Byte | obj is null
			return false ;
		}
	}
	
	public float floatValue() {
		return (float) this.value;
	}

	public int hashCode() {
		return this.value ;
	}
	
	public int intValue() {
		return (int) this.value;
	}
	
	public long longValue() {
		return (long) this.value;
	}
	
	public short shortValue() {
		return (short) this.value;
	}

	public String toString() {
		return Integer.toString(this.value, 10);
	}

}
