/*
 * Java
 *
 * Copyright 2008-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.io;

import com.is2t.tools.ArrayTools;

public abstract class OutputStream implements Closeable, Flushable {

    public OutputStream() {
    }

    public void close() throws IOException {
    	// does nothing
    }

    public void flush() throws IOException {
    	// does nothing
    }
    
    public void write(byte[] b) throws IOException {
    	this.write(b, 0, b.length) ;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        ArrayTools.checkBounds(b, off, len);
    	//avoid underflow by decrementing len;
    	//ArrayIndexOutOfBoundsException is a subclass of IndexOutOfBounds
    	while(--len >= 0) {
    		this.write(b[off++]);
    	}
    }
    
    public abstract void write(int b) throws IOException ;

}
