/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.io;

import ej.annotation.Nullable;

public class FilterInputStream extends InputStream {

	@Nullable 
	protected volatile InputStream in;

	protected FilterInputStream(@Nullable InputStream in) {
		this.in = in;
		// When passing a null InputStream, subclass must override 
		// all default InputStream methods implementation
	}

	public int available() throws IOException {
		InputStream in = this.in;
		assert in != null; 
		return in.available();
	}

	public void close() throws IOException {
		InputStream in = this.in;
		assert in != null;
		in.close();
	}

	public synchronized void mark(int readlimit) {
		InputStream in = this.in;
		assert in != null; 
		in.mark(readlimit);
	}

	public boolean markSupported() {
		InputStream in = this.in;
		assert in != null; 
		return in.markSupported();
	}

	public int read() throws IOException {
		InputStream in = this.in;
		assert in != null; 
		return in.read();
	}

	public int read(byte[] b) throws IOException {
		return this.read(b, 0, b.length);
	}

	public int read(byte[] b, int off, int len) throws IOException {
		InputStream in = this.in;
		assert in != null; 
		return in.read(b, off, len);
	}

	public synchronized void reset() throws IOException {
		InputStream in = this.in;
		assert in != null; 
		in.reset();
	}

	public long skip(long n) throws IOException {
		InputStream in = this.in;
		assert in != null; 
		return in.skip(n);
	}
}
