/*
 * Java
 *
 * Copyright 2010-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.error;

public class Message {
	
	private Message() {
	}

	/**
	 * Return a string representation of the message
	 */
	public static String at(ErrorMessages messages, int index) {
		return new StringBuffer(messages.category()).append(':').append('E')
								.append('=').append(index).toString();
	}

	/**
	 * Return a string representation of the message, all values printed at the end in
	 * sequence separated by a SPACE.
	 */
	public static String at(ErrorMessages messages, int index, Object[] values) {
		StringBuffer stream = new StringBuffer(at(messages,index));
		if (values != null){
			int length = values.length;
			for (int i=-1; ++i<length;){
				stream.append(' ');
				stream.append(values[i]);
			}
		}
		return stream.toString();
	}
	
	/**
	 * Returns a string representation of the message
	 * identified by the given index in the messages pool.
	 * @param messages the pool of messages
	 * @param index the index of the message to print
	 * @param value data associated with the message
	 * @return a string representation of the message
	 */
	public static String at(ErrorMessages messages, int index, Object value) {
		return at(messages, index)+" ("+value+")";
	}
	
}
