/*
 * Java
 *
 * Copyright 2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.LOCAL_VARIABLE;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates that a field, local variable, method return value or parameter can be <code>null</code>.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(value = { FIELD, LOCAL_VARIABLE, METHOD, PARAMETER })
public @interface Nullable {
	// Nothing to do.
}
