/*
 * Java
 *
 * Copyright 2007-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.vm.support.util;

import com.is2t.vm.support.lang.Systools;


public class EncUS_ASCII extends EncodingConversion{
	
	public EncUS_ASCII(String enc) {
		super(enc);
	}

	public int decode(byte[] bytes, int[] bytesOffset, int bytesLength, char[] chars, int offset, int length) {
		int nb = Math.min(bytesLength, length);
		Systools.byteArrayToCharArray(bytes, bytesOffset[0], chars, offset, nb);
		bytesOffset[0] += nb;
		return nb;
	}

	public int encode(char[] chars, int[] charsOffset, int charsLength, byte[] bytes, int offset, int length) {
		int nb = Math.min(charsLength, length);
		Systools.charArrayToByteArray(chars, charsOffset[0], bytes, offset, nb);
		charsOffset[0] += nb;
		return nb;
	}
	
	public int getMaxBytesPerChar() {
		return 1; // 1<->1
	}
	
}
