/*
 * Java
 *
 * Copyright 2008-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.vm.support.lang;

/**
 * Helper class
 */
public final class Systools{
	
	private Systools() {
	}

	/**
	 * See {@link String#regionMatches(boolean, int, String, int, int)}.
	 * Written in native side for speed consideration
	 * @param src is a non null String
	 * @param other is a non null String
	 */
    public static native boolean regionMatches(String src, int toffset, String other, int ooffset, int len);

    /**
     * Fast copy byte[]->char[]
     */
    public static native void byteArrayToCharArray(byte[] src, int srcBegin, char[] dest, int destBegin, int length);

    /**
     * Fast copy char[]->byte[]
     */
    public static native void charArrayToByteArray(char[] src, int srcBegin, byte[] dest, int destBegin, int length);

    /**
     * 	Add the int i representation in base radix in the chars and returns the number of characters.
     * 	The result is stored at the end of chars within ptrPos and chars.length - ptrPos
     *  Callers assume that there is enough space in the chars
     *
     * @param i the integer to write
     * @param radix
     * @param chars
     * @return
     */
	public static native int appendInteger(int i, int radix, char[] chars);

	/**
	 * return the character whose value is digit
	 */
	public static char charValue(int digit){
		// sequence of if statement is more efficient than a lookup swith
		if( digit >=0 && digit <=9) {
			return (char) (digit + '0');
		}
		if(digit >=10 && digit <=35) {
			return (char) (digit + ('a' -10));
		}
		throw new IndexOutOfBoundsException();
	}
	
	/**
	 * @return the simple name for the given classname
	 * 
	 * @see Class#getSimpleName()
	 */
	public static String getSimpleName(final String classname){
		
		try{
			StringBuilder brackets = new StringBuilder();
			String simplename = classname;

			if(simplename.charAt(0)=='['){
				//array
				brackets.append("[]");//$NON-NLS-1$
				int index = 0;
				//parse all the dimensions '['
				while(simplename.charAt(++index) == '['){
					brackets.append("[]");//$NON-NLS-1$
				}

				switch(simplename.charAt(index)){
				case 'Z':
					simplename = "boolean";//$NON-NLS-1$
					break;
				case 'B':
					simplename = "byte";//$NON-NLS-1$
					break;
				case 'C':
					simplename = "char";//$NON-NLS-1$
					break;
				case 'S':
					simplename = "short";//$NON-NLS-1$
					break;
				case 'I':
					simplename = "int";//$NON-NLS-1$
					break;
				case 'J':
					simplename = "long";//$NON-NLS-1$
					break;
				case 'F':
					simplename = "float";//$NON-NLS-1$
					break;
				case 'D':
					simplename = "double";//$NON-NLS-1$
					break;
				case 'L':
					//array of references
					simplename = simplename.substring(index+1, simplename.length()-1);//remove 'L' and ';'
					break;
				}
			}

			int lastDot = simplename.lastIndexOf('.');
			if(lastDot != -1){
				//if there is a package, remove package name
				simplename = simplename.substring(lastDot+1);
			}

			int indexOfDollar = simplename.lastIndexOf('$');
			if(indexOfDollar != -1){
				//inner type

				//remove all potential digit
				int index = indexOfDollar;
				int simplenameLength = simplename.length();
				while(++index<simplenameLength && Character.isDigit(simplename.charAt(index)));
				simplename = simplename.substring(index);
			}

			return brackets.insert(0, simplename).toString();
		}
		catch(IndexOutOfBoundsException e){
			//invalid classname
			throw new InternalError(classname);
		}
	}

}
