/*
 * Java
 *
 * Copyright 2008-2014 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.vm.support.lang;


public class SupportNumber {

	public static final double DOUBLE_NaN = 0d/0d;
	public static final double DOUBLE_MAX_VALUE = 1.7976931348623157E308d;
	public static final double DOUBLE_MIN_VALUE = 4.9E-324d;
	public static final double DOUBLE_NEGATIVE_INFINITY = -1d/0d;
    public static final double DOUBLE_POSITIVE_INFINITY = 1d/0d;
    public static final double DOUBLE_MIN_NORMAL = 0x1.0p-1022;
	public static final int DOUBLE_MAX_EXPONENT = 1023;
	public static final int DOUBLE_MIN_EXPONENT = -1022;
	public static final int DOUBLE_SIZE = 64;

	public static final float FLOAT_NaN = 0f/0f;
	public static final float FLOAT_MAX_VALUE = 3.4028235E38f;
	public static final float FLOAT_MIN_VALUE = 1.4E-45f;
    public static final float FLOAT_NEGATIVE_INFINITY = -1f/0f;
    public static final float FLOAT_POSITIVE_INFINITY = 1f/0f;
    public static final float FLOAT_MIN_NORMAL = 0x1.0p-126f;
    public static final int FLOAT_MAX_EXPONENT = 127;
 	public static final int FLOAT_MIN_EXPONENT = -126;
 	public static final int FLOAT_SIZE = 32;
	
	  /**
     * Returns a String representation of this Double object. The primitive
     * double value represented by this object is converted to a string exactly
     * as if by the method toString of one argument.
     * 
     * Target specific
     */
	native public static String toStringDouble(double d);
	//  public static String toString(double d) {
	//
	//  long bits = Double.doubleToLongBits(d); // representation interne du flottant
	//  if(bits==naNBits)
	//      return "NaN";
	//  if (d == Double.NEGATIVE_INFINITY)
	//      return "-Infinity";
	//  if (d == Double.POSITIVE_INFINITY)
	//      return "Infinity";
	//  if (bits == 0)
	//      return "0.0";
	//  if (bits == Long.MIN_VALUE) // un 1 pour le signe puis des 0
	//      return "-0.0";
	//
	//  boolean scientificValue =  ((d<1.0E-3d) || (d>=1.0E7d)) && ((d>-1.0E-3d) || (d<=-1.0E7d));
	//
	//  byte[] data = toStringNative_(d, scientificValue);
	//
	//  int expIndex = data.length;
	//  if(scientificValue)
	//  {
	//      while(--expIndex > 0 && data[expIndex]!=(byte)'E');//look for the 'E'
	//  }
	//
	//  int maxEndIndex;
	//  if(d >= 0.0d)
	//      maxEndIndex = DOUBLE_STRING_MAX_DIGIT;//include the dot '.'
	//  else
	//      maxEndIndex = DOUBLE_STRING_MAX_DIGIT+1;//include the dot '.' and the '-'
	//
	//  if(maxEndIndex >= expIndex)
	//      maxEndIndex= expIndex-1;
	//
	//  while(maxEndIndex > 0 && data[maxEndIndex]==(byte)'0')//look for the last decimal digit different from 0
	//      maxEndIndex--;
	//
	//  if(data[maxEndIndex] == (byte)'.')//at least one decimal digit, even if it is a 0
	//      maxEndIndex++;
	//
	//  if(scientificValue)
	//  {
	//      //append the exposant
	//      data[++maxEndIndex] = (byte)'E';
	//
	//      //append the '-' and skip the '+'
	//      if(data[++expIndex]=='-')
	//          data[++maxEndIndex]='-';
	//
	//      //append the exposant value
	//      int end = data.length;
	//      while(++expIndex < end)
	//      {
	//          data[++maxEndIndex] = data[expIndex];
	//      }
	//  }
	//
	//  return new String(data, 0, maxEndIndex+1);
	//}
	
	//blackfin C specific method
	//this method uses the sprintf C function :
	//  - NOT scientific notation : sprintf(cString,"%.16Lf",d)
	//  - scientific notation : sprintf(cString,"%.16LE",d)
	//this method assumes that the scientific notation is used when the double value is less than 1E-3 or not less than 1E7
	//private static byte[] toStringNative_(double d, boolean scientific) {
	//	throw new InternalLimitsError(ErrorMessages.InternalLimitsError);
	//}

	
	/**
	 * Returns a new double initialized to the value represented by the
	 * specified String, as performed by the valueOf method of class Double.
	 * 
	 * Target specific
	 */
	public static double parseDouble(String s) throws NumberFormatException {
	 	s = s.trim();	// it will check implicitly if s is null, a NullPointerException is thrown if s is null (as expexted by CLDC specification)
    	// here, s is sure to be not null
    	
    	// first, check if the string is "NaN"
    	// because the native method returns NaN when there is a number format exception
    	byte[] array = s.getBytes();
    	int length = array.length ;
    	if (length == 3 || length == 4)
    	{
    		int ptr = 0 ;
    		if (array[ptr] == (byte)'-' || array[ptr] == (byte)'+')
    			ptr++ ;
    		if(length - ptr == 3 && array[ptr++]==(byte)'N' && array[ptr++]==(byte)'a' && array[ptr++]==(byte)'N')
    			return Double.NaN;
    	}
    	
    	double result = parseDoubleNative(s);
    	if( !Double.isNaN(result) )
    		return result;
    	
    	throw new NumberFormatException();
    	
	//        s = s.trim();
	//        if (s.length() == 0)
	//            throw new NumberFormatException(s) ;
	//
	//        byte[] array = s.getBytes();
	//
	//        if(array[0]==(byte)'N' && array[1]==(byte)'a' && array[2]==(byte)'N')
	//            return Double.NaN;
	//
	//        if(  array[0]==(byte)'I'
	//          && array[1]==(byte)'n'
	//          && array[2]==(byte)'f'
	//          && array[3]==(byte)'i'
	//          && array[4]==(byte)'n'
	//          && array[5]==(byte)'i'
	//          && array[6]==(byte)'t'
	//          && array[7]==(byte)'y'
	//          )
	//            return Double.POSITIVE_INFINITY;
	//
	//        if(  array[0]==(byte)'-'
	//          && array[0]==(byte)'I'
	//          && array[1]==(byte)'n'
	//          && array[2]==(byte)'f'
	//          && array[3]==(byte)'i'
	//          && array[4]==(byte)'n'
	//          && array[5]==(byte)'i'
	//          && array[6]==(byte)'t'
	//          && array[7]==(byte)'y'
	//          )
	//            return Double.NEGATIVE_INFINITY;
	//
	//
	//        return parseDoubleNative(s);
    }
	
	//Returns NaN if the given string is not a valid double
	native public static double parseDoubleNative(String s);
	
	
	  /**
     * Returns a String representation of this Float object. The primitive
     * float value represented by this object is converted to a string exactly
     * as if by the method toString of one argument.
     * 
     * Target specific
     */
	native public static String toStringFloat(float f);
//  public static String toString(float f) {
//
//  int bits = Float.floatToIntBits(f); // internal representation of the floating point number
//  if (bits == naNBits)
//      return "NaN";
//  if (f == Float.NEGATIVE_INFINITY)
//      return "-Infinity";
//  if (f == Float.POSITIVE_INFINITY)
//      return "Infinity";
//  if (bits == 0)
//      return "0.0";
//  if (bits == Integer.MIN_VALUE) // a 1 for the sign and then some 0
//      return "-0.0";
//
//  boolean scientificValue = ((f<1.0E-3f) || (f>=1.0E7f)) && ((f>-1.0E-3f) || (f<=-1.0E7f));
//
//  byte[] data = toStringNative_(f, scientificValue);
//
//  int expIndex = data.length;
//  if(scientificValue)
//  {
//      while(--expIndex > 0 && data[expIndex]!=(byte)'E');//look for the 'E'
//  }
//
//  int maxEndIndex;
//  if(f >= 0.0d)
//      maxEndIndex = FLOAT_STRING_MAX_DIGIT;//include the dot '.'
//  else
//      maxEndIndex = FLOAT_STRING_MAX_DIGIT+1;//include the dot '.' and the '-'
//
//  if(maxEndIndex >= expIndex)
//      maxEndIndex= expIndex-1;
//
//  while(maxEndIndex > 0 && data[maxEndIndex]==(byte)'0')//look for the last decimal digit different from 0
//      maxEndIndex--;
//
//  if(data[maxEndIndex] == (byte)'.')//at least one decimal digit, even if it is a 0
//      maxEndIndex++;
//
//  if(scientificValue)
//  {
//      //append the exposant
//      data[++maxEndIndex] = (byte)'E';
//
//      if(data[++expIndex]=='-')//append the '-' and skip the '+'
//          data[++maxEndIndex]='-';
//
//      //append the exposant value
//      int end = data.length;
//      while(++expIndex < end)
//      {
//          data[++maxEndIndex] = data[expIndex];
//      }
//  }
//
//  return new String(data, 0, maxEndIndex+1);
//}

//blackfin C specific method
//this method uses the sprintf C function :
//  - NOT scientific notation : sprintf(cString,"%.8f",f)
//  - scientific notation : sprintf(cString,"%.8E",f)
//this method assumes that the scientific notation is used when the float value is less than 1E-3 or not less than 1E7
//private static byte[] toStringNative_(float f, boolean scientific){
//	throw new InternalLimitsError(ErrorMessages.InternalLimitsError);
//}
//native private static byte[] toStringNative(float f, boolean scientific);

//public static String toString(float f) {
//	int bits = Float.floatToIntBits(f); // internal representation of the floating point number
//	if (bits == naNBits)
//		return "NaN";
//	if (f == Float.NEGATIVE_INFINITY)
//		return "-Infinity";
//	if (f == Float.POSITIVE_INFINITY)
//		return "Infinity";
//	if (bits == 0)
//		return "0.0";
//	if (bits == Integer.MIN_VALUE) // a 1 for the sign and then some 0
//		return "-0.0";
//	boolean signe = (bits & signMask) != 0; // true if the number is < 0
//	/** * exponent extraction ** */
//	int exp = bits & noSignMask; // we suppress the sign
//	exp = exp >> mantissaSize; // and the mantissa
//	boolean normalized = (exp != 0);
//	exp -= expRelative; // converts from 'code relative to expRelative' =>
//						// 'binary'
//	/** * mantissa extaction ** */
//	int mantisse = bits & mantissaMask; // we suppress the exponent
//	if (normalized) {
//		mantisse |= implicitBitMask; // we add the implicit bit
//	} else {
//		exp = denormalizedExp;
//	}
//	/***********************************************************************
//	 *
//	 * We count the number of significative digits in the mantissa i.e. the
//	 * total number minus the number of 0 at the end (without the implicit bit
//	 * at the beginning).
//	 *
//	 * We substract the exponent to that result. We obtain the number of digits after
//	 * the floating point. At the same time we keep significatives bits from the mantissa
//	 * so that we will be able to compute the integer value corresponding to the
//	 * float without the point.
//	 */
//	int nbSig = mantissaSize; // number of signicative digits in the mantissa
//	int valInt = mantisse;
//	while ((valInt & 1) == 0 && nbSig > exp) {
//		valInt = valInt >> 1;
//		nbSig--;
//	}
//	int fracSize; // number of digits after the point
//	// we store valInt in a BigInt only if necessary
//	BigInt valBigInt = null;
//	if (nbSig > exp) {
//		// The number is not an int
//		valBigInt = new BigInt(valInt);
//		fracSize = nbSig - exp;
//		// We compute the number without the point:
//		// we have valBigInt=f*2^tailleFrac
//		// we multiply it by 5^tailleFrac
//		// and we obtain f*10^tailleFrac
//		try {
//			valBigInt.multiplyByXExpY(5, fracSize);
//		} catch (BigIntOverFlowException e) {
//			e.printStackTrace();
//		} catch (BigIntInternalOverFlowException e) {
//			e.printStackTrace();
//		}
//	} else {
//		// The floating point number is an integer!
//		fracSize = exp - nbSig;
//		// We compute the number without the point:
//		// we have f*2^-tailleFrac
//		// we multiply it by 2^tailleFrac
//		// and we obtain f
//		if (exp >= representationSize-1) { // overflow
//			valBigInt = new BigInt(valInt);
//			try {
//				valBigInt.multiplyByXExpY(2, fracSize);
//			} catch (BigIntOverFlowException e) {
//				e.printStackTrace();
//			} catch (BigIntInternalOverFlowException e) {
//				e.printStackTrace();
//			}
//		} else { // no need to use a bigInt
//			valInt <<= fracSize; // valInt*=(2^tailleFrac)
//		}
//		// integer => no digits after the point
//		fracSize = 0;
//	}
//	/**
//	 * Where do we round:
//	 * we compute the threshold 'halfDelta' which is the half of
//	 * the threshold between f and his follower f+.
//	 * the 10-exponent 'round' of that number correspond to the first digit to
//	 * remove. In other words  we round at 10^(round-1)
//	 */
//	/** *********** Nouveau calcul *************** */
//	int round = expHalfDeltas[exp - denormalizedExp]; // exponent of (Delta/2)
//	int nbInsigDigits = fracSize + round + 1; // number of digits to remove
//	if (nbInsigDigits > 0) {
//		fracSize -= nbInsigDigits;
//		int digitF;
//		int digitFm;
//		int digitFp;
//		boolean roundUp = false;
//		if (valBigInt != null) {
//			//First we round at 10^round => we remove (nbInsigDigits-1) digits
//			if (nbInsigDigits > 1) {
//				while (nbInsigDigits > 2) { // We remove nbInsigDigits-2 digits
//					valBigInt.divideByTen();
//					nbInsigDigits--;
//				}
//				try {
//					valBigInt.add(5); // We add 5 to round to the closest
//				} catch (BigIntInternalOverFlowException e1) {
//					// should not happen...
//					e1.printStackTrace();
//				}
//				roundUp = (valBigInt.getValModuloTen() < 5); // true => we increment last digit
//				valBigInt.divideByTen(); // We remove another digit
//			}
//			// Let's use delta in the forme deltaMant^e where e is the exponent of delta/2
//			int deltaMant = halfDeltasInt[-denormalizedExp + exp + 1];
//			if (expHalfDeltas[-denormalizedExp + exp + 1] > expHalfDeltas[-denormalizedExp+ exp]) {
//				deltaMant *= 10;
//			}
//			digitF = (int) valBigInt.getValModuloTen(); // last digit in f
//			digitFm = digitF - deltaMant; // last digit in f+
//			digitFp = digitF + deltaMant; // last digit in f-
//			if (roundUp) {
//				digitFm--;
//				digitFp--;
//			}
//			if ( // The previous digit don't change
//					((digitF < 5 && 						// in
//							((digitFm >= -5 && digitFm < 5) // f and f-
//							|| digitFp < 5)) 				// f et f+
//			||   // or it is incremented by 1
//					(digitF >= 5 && // for f
//					 digitFp >= 5 && // and f+
//					 digitFp < 15))) { // previous digit is incremented by 2 for f+
//				// we keep on digit more. otherwise we fall back on f- or f+
//				fracSize++;
//			} else {
//				try {
//					valBigInt.add(5); // We add 5 to round to the closest
//					if (roundUp && (valBigInt.getValModuloTen() == 0)) {
//						// We round up at the previous level while we didn't had to
//						// (1.49 is rounded to 1 and not to 2!!
//						// we must remove 1 to the value
//						valBigInt.sub(1);
//					}
//				} catch (BigIntInternalOverFlowException e) {
//					e.printStackTrace();
//				} catch (BigIntOverFlowException e) {
//					// valBigInt was 0
//					// should not happen
//					e.printStackTrace();
//				}
//				valBigInt.divideByTen(); // we remove last digit
//			}
//			// We remove trailing 0 at the end of the fraction part
//			// i.e. we remove at most fracSize 0 to the value
//			fracSize = valBigInt.removeTrailingZeros(fracSize);
//		} else {
//			// on commence par arrondir ? 10^arrondi pres
//			if (nbInsigDigits > 1) {
//				while (nbInsigDigits > 2) { // suppression de
//					// nbInsigDigits-2 chiffres
//					valInt /= 10;
//					nbInsigDigits--;
//				}
//				valInt += 5; // on deborde pour arrondir au plus proche
//				roundUp = (valInt % 10) < 5; // si vrai on a incremente le
//											 // dernier digit
//				valInt /= 10; // on enleve un chiffre de plus
//			}
//			int deltaMant = halfDeltasInt[-denormalizedExp + exp + 1];
//			if (expHalfDeltas[-denormalizedExp + exp + 1] > expHalfDeltas[-denormalizedExp + exp]) {
//				deltaMant *= 10;
//			}
//			digitF = valInt % 10;
//			digitFm = digitF - deltaMant; // a definir
//			digitFp = digitF + deltaMant; // a definir
//			if(roundUp){
//				digitFm--;
//				digitFp--;
//			}
//			if ( // Le chiffre precedent ne change pas
//				((digitF < 5 && 						// pour
//						((digitFm >= -5 && digitFm < 5) // v et v-
//						|| digitFp < 5)) 				// v et v+
//			|| // ou il est incremente de 1(!)
//				(digitF >= 5 && // pour v
//				 digitFp >= 5 && // et v+
//				 digitFp <= 5))) { // cas ou le chiffre precedent est increment? de 2 pour v+
//				// dans ce cas on garde un chiffre de plus sinon on retombe
//				// sur v- ou v+
//				fracSize++;
//			} else {
//				valInt += 5; // on fait deborder pour arriver au plus
//							 // proche
//				if (roundUp && (valInt % 10) == 0) {
//					// On a fait un double arrondi
//					// Il faut decrementer valInt
//					valInt--;
//				}
//				valInt /= 10; // on enleve le dernier chiffre
//			}
//			// on supprime les 0 finals de la partie fractionnaire
//			// i.e. on supprime au plus tailleFrac zeros ? la fin
//			while (fracSize >= 0 && valInt % 10 == 0) {
//				valInt /= 10;
//				fracSize--;
//			}
//		}
//	}
//	// la chaine qu'on va renvoyer
//	char[] buffer = new char[strSize];
//	int position = strSize - 1; // on la remplit par la fin
//	int nbEmptyBoxes = 0; // nombre de positions vides ? la fin de buffer
//						  // (voir affichage de l'exposant)
//	if ((f >= 1E-3f && f < 1E7f) || (f <= -1E-3f && f > -1E7f)) {
//		// partie fractionnaire
//		if (fracSize != 0) {
//			// On affiche les tailleFrac derniers chiffres de val(Big)Int
//			if (valBigInt != null) {
//				valBigInt.fillWithLast(fracSize, buffer, strSize - 1);
//				position -= fracSize;
//			} else {
//				while (valInt != 0) {
//					buffer[position] = (char) ((valInt % 10) + '0');
//					valInt /= 10;
//					position--;
//				}
//				while (position >= 0) {
//					buffer[position] = '0';
//					position--;
//				}
//			}
//		} else {
//			// on a toujours au moins un chiffre apres la virgule
//			buffer[position] = '0';
//			position--;
//		}
//		buffer[position] = '.';
//		position--;
//		// partie entiere
//		if (valBigInt != null) {
//			int oldpos = position;
//			position = valBigInt.fillWithValueWithoutLast(fracSize,
//					buffer, position);
//			if (position - oldpos == 0) {
//				buffer[position] = '0';
//				position--;
//			}
//		} else {
//			if (valInt == 0) {
//				buffer[position] = '0';
//				position--;
//			} else {
//				while (valInt != 0) {
//					buffer[position] = (char) ((valInt % 10) + '0');
//					valInt /= 10;
//					position--;
//				}
//			}
//		}
//		if (signe) {
//			buffer[position] = '-';
//			position--;
//		}
//	} else { // affichage en notation scientifique
//		int exp10; // exposant en base 10
//		/*
//		 * exp10 vaut le nombre de chiffres apres la virgule de la mantisse
//		 * (dont les 0 ? la fin) i.e. le nombre total de chiffres - 1
//		 */
//		// on passe les zeros non significatifs
//		if (valBigInt != null) {
//			exp10 = valBigInt.removeTrailingZeros();
//		} else {
//			exp10 = 0;
//			while (valInt % 10 == 0) {
//				exp10++;
//				valInt /= 10;
//			}
//		}
//		position = strSize - 1 - strExpSize; // on reserve de la place pour
//											 // l'exposant
//		// remplissage de la mantisse base 10
//		int tailleInt = strSize - 1 - strExpSize;
//		if (valBigInt != null) {
//			/*
//			 * tailleInt=valBigInt.getMaxNbDigits(); tailleInt++; // au cas
//			 * o? on arrondirait en rajoutant un chiffre
//			 */
//			position = valBigInt.fillWithValue(buffer, position);
//		} else {
//			// On prevoit un de plus au cas o? on arrondirait en ajoutant
//			// un chiffre
//			while (valInt != 0) {
//				buffer[position] = (char) ((valInt % 10) + '0');
//				position--;
//				valInt /= 10;
//			}
//		}
//		tailleInt -= position;
//		exp10 += tailleInt - 1;
//		if (exp < 0) { // Pourquoi deja??
//			exp10 -= fracSize;
//		}
//		if (fracSize < 0) {
//			// dans valBigInt, il nous manque -tailleFrac par rapport ? la
//			// valeur entiere
//			exp10 -= fracSize;
//		}
//		// positionnement du . apres le premier chiffre et
//		// eventuellement du 0
//		if (position == strSize - strExpSize - 2) {
//			// cas ou il n'y a qu'un seul chiffre
//			buffer[position - 1] = buffer[position + 1];
//			buffer[position] = '.';
//			buffer[position + 1] = '0';
//			position -= 2;
//		} else {
//			buffer[position] = buffer[position + 1];
//			buffer[position + 1] = '.';
//			position--;
//		}
//		// Le signe de la mantisse
//		if (signe) {
//			buffer[position] = '-';
//			position--;
//		}
//		/** *** remplissage de l'exposant */
//		// l'exposant commence ? la position strSize-strExpSize
//		boolean exp10Neg = (exp10 < 0);
//		int absExp10 = exp10Neg ? -exp10 : exp10; // we need absolute
//		// value to print it...
//		int unites = absExp10 % 10;
//		int dizaines = (absExp10 / 10) % 10;
//		buffer[strSize - strExpSize] = 'E';
//		int positionExp = strSize - strExpSize + 1;
//		if (exp10Neg) {
//			buffer[strSize - strExpSize + 1] = '-';
//			positionExp++;
//		}
//		if (dizaines != 0) {
//			buffer[positionExp] = (char) ('0' + dizaines);
//			positionExp++;
//			buffer[positionExp] = (char) ('0' + unites);
//			positionExp++;
//		} else {
//			buffer[positionExp] = (char) ('0' + unites);
//			positionExp++;
//		}
//		nbEmptyBoxes = strSize - positionExp;
//		/** *** fin remplissage de l'exposant */
//		// recopie de la mantisse base 10 dans le buffer final
//	}
//	return new String(buffer, position + 1, strSize - (position + 1)
//			- nbEmptyBoxes); // y a recopie (rajouter parametre false)
//

	
	/**
	 * Returns a new float initialized to the value represented by the
	 * specified String, as performed by the valueOf method of class Float.
	 * 
	 * Target specific
	 */
	public static float parseFloat(String s) throws NumberFormatException {
		s = s.trim() ;	// it will check implicitly if s is null, a NullPointerException is thrown if s is null (as expexted by CLDC specification)
		// here, s is sure to be not null

		// first check if the string is "NaN"
		// because the native method returns NaN when there is an number format exception
		byte[] array = s.getBytes();
		int length = array.length ;
		if (length == 3 || length == 4)
		{
			int ptr = 0 ;
			if (array[ptr] == (byte)'-' || array[ptr] == (byte)'+')
				ptr++ ;
			if(length - ptr == 3 && array[ptr++]==(byte)'N' && array[ptr++]==(byte)'a' && array[ptr++]==(byte)'N')
				return Float.NaN;
		}

		float result = parseFloatNative(s);
		if( !Float.isNaN(result) )
			return result;

		throw new NumberFormatException();
		    	
//		    	s = s.trim();
//		        if (s.length() == 0)
//		            throw new NumberFormatException(s) ;
//
//		        byte[] array = s.getBytes();
//
//		        if(array[0]==(byte)'N' && array[1]==(byte)'a' && array[2]==(byte)'N')
//		        	return Float.NaN;
//
//		        if(  array[0]==(byte)'I'
//		          && array[1]==(byte)'n'
//		          && array[2]==(byte)'f'
//		          && array[3]==(byte)'i'
//		          && array[4]==(byte)'n'
//		          && array[5]==(byte)'i'
//		          && array[6]==(byte)'t'
//		          && array[7]==(byte)'y'
//		          )
//		            return Float.POSITIVE_INFINITY;
//
//		        if(  array[0]==(byte)'-'
//		          && array[0]==(byte)'I'
//		          && array[1]==(byte)'n'
//		          && array[2]==(byte)'f'
//		          && array[3]==(byte)'i'
//		          && array[4]==(byte)'n'
//		          && array[5]==(byte)'i'
//		          && array[6]==(byte)'t'
//		          && array[7]==(byte)'y'
//		          )
//		            return Float.NEGATIVE_INFINITY;
//
//		        return parseFloatNative(s);
	}
		    
	native public static float parseFloatNative(String s) throws NumberFormatException;
		    
//			public static float parseFloat(String s) throws NumberFormatException {
//			    char[] chars = s.trim().toCharArray();
//				if (chars.length == 0)
//				    throw new NumberFormatException(s) ;
//
//				int offset = 0 ; // index of first valid character
//				int leadingZeros = 0 ; // leading zeros before the decimal point
//				int zeros = 0 ; // ledaing zeros after the decimal point
//				int i ;
//				boolean neg = false ;
//				try {
//				    // Sign
//				    switch (chars[0]) {
//					    case '-': neg=true;
//					    case '+': ++offset ;
//				    }
//					// NaN or Infinity
//					if (chars[offset]=='N') {
//					    if (chars[++offset]=='a' && chars[++offset]=='N' && offset==chars.length-1) {
//					        return Float.NaN ;
//					    }
//					    throw new NumberFormatException(s) ;
//					}
//					else if (chars[offset]=='I') {
//					    boolean isInfinity = true ;
//					    char[] infinityChars = {'I','n','f','i','n','i','t','y'} ;
//					    int j=0 ;
//					    for (; j < infinityChars.length; ++j) {
//					        if (chars[offset+j] != infinityChars[j])
//					            isInfinity = false ;
//					    }
//					    if (isInfinity && offset+j==chars.length)
//					        return neg ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY ;
//					    throw new NumberFormatException(s) ;
//					}
//
//				    // Leading zeros
//				    while (chars[offset]=='0') {
//						++offset ;
//						++leadingZeros ;
//				    }
//
//					// Leading zeros after the decimal point, e.g. 0.0000002594210E32
//					i = offset ;
//					if (chars[i]=='.') {
//					    while (chars[++i]=='0') ;
//					    zeros = --i - offset ;
//					    offset = i ;
//					    chars[offset] = '.' ;
//					}
//
//				} catch (ArrayIndexOutOfBoundsException e) {
//				    if (offset <= 1 && chars[0] != '0')
//				        throw new NumberFormatException(s) ;
//					return 0.0f ;
//				}
//
		//
//				// Increase i until we find a decimal point at chars[i]
//				// or another character which is neither a digit nor a '.'
//				int iDecPoint = -1 ;
//				while (i < chars.length) {
//					if (!Character.isDigit(chars[i])) {
//						if (chars[i] != '.' || iDecPoint >= 0)
//							break ;
//						iDecPoint = i ;
//					}
//					++i ;
//				}
//
//				int mantLen ; // Number of digits in the mantissa
//				int preExp ;  // Number of truncated digits in case of overflow
		//
//				mantLen = iDecPoint < 0 ? (iDecPoint = i)-offset : i-offset-1 ;
//				if (mantLen == 0 && leadingZeros==0) // possibly Eii --> invalid
//					throw new NumberFormatException(s) ;
//
//				// In case of overflow (mantLen > 18), preExp reminds the number of power of 10
//				// by which we must increase the result to take the lost digits into account.
//				preExp = mantLen > 18 ?
//				        ((iDecPoint-offset) - (mantLen=18)) :
//				        ((iDecPoint-offset) - mantLen) ;
//
//				// Accumulate the integer part of the number
//				long intAccumul = 0 ;
//				for (int j=offset; j<offset+mantLen; j++) {
//					if (Character.isDigit(chars[j]))
//					    intAccumul = 10 * intAccumul + (chars[j]-'0');
//					else if (chars[j] == '.')
//						++mantLen ;
//					else {
//					    throw new NumberFormatException(s) ;
//					}
//				}
//
//				// Parsing of the exponent part of the number
//				int exponent = 0 ;
//				boolean expNeg = false ;
//				if (i < chars.length-1 && (chars[i] == 'E' || chars[i] == 'e')) {
//					i++ ;
//					if ((expNeg = (chars[i] == '-')) || (chars[i] == '+'))
//						i++ ;
		//
//					if (!Character.isDigit(chars[i])) {  // ex: "125.147E-j"
//						throw new NumberFormatException(s) ;
//					} else {
//					    try {
//					        // Leading zeros
//							while(chars[i]=='0')
//							    ++i ;
//							// Conversion string-->integer
//							boolean maybeZero = false ;
//							while (i<chars.length && Character.isDigit(chars[i])) {
//								exponent = exponent * 10 + (chars[i++]-'0') ;
//								if (exponent < 0 && mantLen > 0) // integer overflow
//								    return expNeg ? neg ? -0.0f : 0.0f : neg ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY ;
//								else if (exponent < 0 && leadingZeros > 0)
//								    maybeZero = true ;
//							}
//							// Check if the string is over
//							if ((i==chars.length-1 && chars[i]!='f' && chars[i]!='F') ||
//								(i<chars.length-1))
//								    throw new NumberFormatException(s) ;
//							if (maybeZero) // now it's sure !
//							    return 0.0f ;
//						} catch (ArrayIndexOutOfBoundsException e) {
//						    exponent = 0 ;
//						}
//					}
//
//				}
//				else if (i==chars.length-1 && chars[i]!='f' && chars[i]!='F') { // last char other than 'd' or 'D'
//				    throw new NumberFormatException(s) ;
//				}
//				else if (i<chars.length-1 && chars[i] != 'E' && chars[i] != 'e') { // e.g. 4565F56 instead 4565E56
//					throw new NumberFormatException(s) ;
//				}
//
//				exponent = expNeg ? preExp - exponent - zeros : preExp + exponent - zeros ;
//				if (expNeg = exponent < 0) {
//					exponent = -exponent ;
//				}
//
//				// Computing of the exponent as a float value
//				float expAccumul ;
//				int   expoTrunc ;
//				float result = intAccumul ;
//				//p("intAccumul="+intAccumul) ;
//				float[] powerOf10 = {10,100,1e4f,1e8f,1e16f,1e32f} ;
//				do {
//				    expAccumul = 1.0f ;
//				    expoTrunc = exponent > 38 ? 38 : exponent ;
//				    exponent -= expoTrunc ;
//					for (i=0; expoTrunc!=0; i++) {
//						if ((expoTrunc & 0x1) == 1) {
//						    expAccumul *= powerOf10[i] ;
//						}
//						expoTrunc >>= 1 ;
//					}
//					// BUG: sometimes the accumulation fails due to the lack of precision
//					// e.g. if you're expecting 1.0E293 you can get 1.00000000001E293 instead !
//
//					// Compute the result, step by step with expAccumul
//					//p("result@pre="+Double.doubleToLongBits(result));
//					result = expNeg ? result/expAccumul : result*expAccumul ;
//					//p("result@post="+Double.doubleToLongBits(result));
//				}
//				while (exponent > 0) ;
//				return neg ? -result : result ;
//			}
//
	
	public native static int parseInt(char[]  chars, int offset, int len, int radix) throws IllegalArgumentException;
	
	/**
	 * return the representation of i as unsigned integer
	 */
	public static String toUnsignedString(int i, int shift) {
		char[] buffer = new char[32];
		int mask = (1<<shift)-1;
		int ptrBuffer = 32;
		do {
			buffer[ --ptrBuffer] = Systools.charValue( i&mask);
			i >>>= shift;
		} while (i!=0);
		return new String ( buffer, ptrBuffer, 32-ptrBuffer, false);
	}
	
	
	public static String toUnsignedStringLong(long i, int shift) {
		char[] buffer = new char[64];
		int mask = (1<<shift)-1;
		int ptrBuffer = 64;
		do {
			buffer[ --ptrBuffer] = Systools.charValue( ((int)i)&mask);
			i >>>= shift;
		} while (i!=0);
		return new String ( buffer, ptrBuffer, 64-ptrBuffer, false);
	}
	
	public static String toStringInteger(int i, int radix) {
		if (radix < Character.MIN_RADIX || radix > Character.MAX_RADIX)
			radix  = 10;

		//  optimization for digits : sure that i <0
		if ( i<0 && i > -radix)
			return  new String ( new char[] {'-', Systools.charValue(-i)}, 0, 2, false);
		else if ( i>=0 && i < radix)
			return  new String ( new char[] {Systools.charValue(i)}, 0, 1, false);
			
		// "optimize" the length of the char array
		// for radixes 2 (lg max=32), 10 (lg max=11) and 16 (lg max=8) + sign
		int charLength = radix > 9 ? 12 : 33;
		char[]  modulos = new char[charLength];
		int ptrPos = Systools.appendInteger( i, radix, modulos);

		return new String (modulos, charLength-ptrPos, ptrPos, false);
	
	}
	
	public static String toStringLong(long i, int radix) {
		
		if (radix < Character.MIN_RADIX || radix > Character.MAX_RADIX)
			radix = 10;
			
		// "optimize" the length of the char array
		int charLength = radix > 9 ? 21: 65;
		char[]  modulos = new char[charLength];
		int ptrPos = toStringLongNative( i, radix, modulos);

		return new String (modulos, charLength-ptrPos, ptrPos, false);
	}
	
	native private  static int  toStringLongNative(long i, int radix, char[] chars) ;

	/**
	 * Parses the string includes in the byte argument (from offset to offset+len) as a signed long in the radix specified
	 */
	public native static long parseLong(char[]  chars, int offset, int len, int radix) throws IllegalArgumentException;

}
