/*
 * Java
 *
 * Copyright 2004-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */ 
package com.is2t.vm.support;

import java.util.TimeZone;

/**
 * APIs for {@link TimeZone} implementation. By default, IS2T EDC-1.x implementation is provided
 * with a simple implementation based on lazy class loading. 
 * @see DefaultTimeZoneImpl
 */
public interface TimeZoneImpl {

	/**
	 * @see TimeZone#getAvailableIDs()
	 */
    String[] getAvailableIDs();

    /**
     * @see TimeZone#getDefault()
     */
	TimeZone getDefault();

	/**
	 * @see TimeZone#getTimeZone(String)
	 */
	TimeZone getTimeZone(String id);
    
}
