/*
 * Java
 *
 * Copyright 2010-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */ 
package com.is2t.vm.support;

import ej.error.ErrorMessages;

/**
 * {@link ImmutableTimeZoneImpl} error messages.
 */
public class TimeZoneErrorMessages implements ErrorMessages{

	public static final int ImmutableNotFound 	= 1;
    public static final int InvalidImmutable	= 2;
   
	public String category() {
		return "TZ";
	}

	public String messageAt(int index) {
		switch(index){
		case ImmutableNotFound : 		return "No immutable named "+ImmutableTimeZoneImpl.ARRAY_ID+".";
		case InvalidImmutable: 			return "Immutable type is invalid.";
		default: 						return ("Unknown error ("+index)+')';
		}
	}

}
