/*
 * Java
 *
 * Copyright 2004-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.vm.support;

import java.util.TimeZone;

/**
 * Default internal implementation of {@link TimeZone} implementation, based on lazy class loading.
 */
public class DefaultTimeZoneImpl implements TimeZoneImpl{

	public static final String SUPPORT_PREFIX = "com.is2t.vm.support."; //$NON-NLS-1$
	
	// available time zones
	// When the system starts, there's only the GMTTimeZone which is loaded
	//
	private static String[] availableIDs = new String[]{"GMT"} ; //$NON-NLS-1$
	
	/**
	 * @see TimeZone#getAvailableIDs()
	 */
    public String[] getAvailableIDs() {
    	return availableIDs ;
    }

	public TimeZone getDefault() {
		String st = System.getPropertyNoCheck(TimeZone.TimeZoneProperty);
    	if (st == null) {
    		return GMTTimeZone.getInstance();
    	}

    	return getTimeZone(st);
	}
	
	/** IST-API
	 * Gets the TimeZone for the given ID.
	 */
	public TimeZone getTimeZone(String id) {
		if(id.equals("GMT")) { //$NON-NLS-1$
			return GMTTimeZone.getInstance();
		}

 		try {
     		// Time zones class names = <ID>TimeZone (e.g. GMTTimeZone)
 			StringBuilder sb = new StringBuilder(SUPPORT_PREFIX)
    			.append(id)
    			.append("TimeZone") ; //$NON-NLS-1$
        	
    		return (TimeZone) Class.forName(sb.toString()).newInstance() ;
    		
    	} catch (IllegalAccessException | ClassNotFoundException | InstantiationException | ClassCastException e) {
    		return GMTTimeZone.getInstance() ;
    	}
    }
}
