/*
 * Java
 *
 * Copyright 2011-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.tools;

import ej.error.ErrorMessages;

public class ToolsErrorMessage implements ErrorMessages {

	public static final int nbMessages = 3 ;

	// Messages on array indexes errors
	public static final int ArrayNegativeOffset = 1;
	public static final int ArrayNegativeLength = 2;
	public static final int ArrayOffsetLengthGreater = 3;
	public static final int ArrayNegativeOffsetPlusLength = 4;

	public String category() {
		return "Generic";
	}

	public String messageAt(int index) {
		switch(index){

		// Messages on array indexes errors
		case ArrayNegativeOffset:		return "Negative offset.";
		case ArrayNegativeLength:		return "Negative length.";
		case ArrayOffsetLengthGreater:	return "Offset + length > object length.";
		case ArrayNegativeOffsetPlusLength:	return "Negative offset + length.";

		default: 						return ("Unknown error ("+index)+')';
		}
	}

}
