/*
 * Java
 *
 * Copyright 2011-2014 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.tools;

public class Rectangle {

	int x;
	int y;
	int width;
	int height;

	public Rectangle(int x, int y, int width, int height) {
		super();
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
	}

	//check that the coordinates of a point are inside a rectangle or not
	public boolean contains(int pointX, int pointY) {
		return GeometryTools.contains(x, y, width, height, pointX, pointY);
	}

	public Rectangle encompass(Rectangle rectangle2) {
		int x1 = Math.min(x, rectangle2.x);
		int y1 = Math.min(y, rectangle2.y);
		int x2 = Math.max(x + width, rectangle2.x + rectangle2.width);
		int y2 = Math.max(y + height, rectangle2.y + rectangle2.height);

		return new Rectangle(x1, y1, x2 - x1, y2 - y1);
	}

	public Rectangle intersection(Rectangle rectangle2) {
		int x1 = Math.max(x, rectangle2.x);
		int y1 = Math.max(y, rectangle2.y);
		int x2 = Math.min(x + width, rectangle2.x + rectangle2.width);
		int y2 = Math.min(y + height, rectangle2.y + rectangle2.height);

		return new Rectangle(x1, y1, x2 - x1, y2 - y1);
	}
}
