/**
 * Java
 *
 * Copyright 2011 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.tools;

public class GenericTools {

	public static int limit(int value, int min, int max) {
		//check bounds
		if(max < min) {
			int tmp = min;
			min = max;
			max = tmp;
		}
		//compute bounded value
		return Math.min(max, Math.max(min, value));
	}

	public static int incrementBounded(int value, int incr, int min, int max) {
		return limit(value + incr, min, max);
	}

	public static int incrementCircular(int value, int incr, int min, int max) {
		//check bounds
		if(max < min) {
			int tmp = min;
			min = max;
			max = tmp;
		}
		//apply increment
		value += incr;
		int range = max - min;
		//compute bounded value
		while(value > max) {
			value -= range;
		}
		while(value < min) {
			value += range;
		}
		return value;
	}

}
