/*
 * Java
 *
 * Copyright 2011-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.tools;

public class BitFieldHelper {
	
	private BitFieldHelper() {
	}

	// inline /!\ if field is a bit-field, work must be done on a local
	public static int setBooleanProperty(int field, boolean value, int mask) {
		if (value) {
			field |= mask;
		} else {
			field &= ~mask;
		}
		return field;
	}

	public static int setBooleanProperty(int field, int mask) {
		return field |= mask;
	}

	public static int unsetBooleanProperty(int field, int mask) {
		return field &= ~mask;
	}

	// inline
	public static boolean getBooleanProperty(int field, int mask) {
		return (field & mask) != 0x0;
	}

	// inline /!\ if field is a bit-field, work must be done on a local
	public static int setIntProperty(int field, int value, int mask, int shift) {
		field &= ~mask; // erase previous value
		field |= (value << shift) & mask;
		return field;
	}

	// inline
	public static int getIntProperty(int field, int mask, int shift) {
		return (field & mask) >>> shift;
	}

}
