/*
 * Java
 *
 * Copyright 2011-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.cldc.support;

import ej.annotation.Nullable;

/**
 * Browse an objects graph from a given root and call {@link #browse(Object)} method for each object.
 */
public abstract class ObjectGraphBrowser {

	public void browseGraph(Object root){
		//first we gather all the family of root
		//Then on each of the children we call the method browse...

		ObjectSet family = new ObjectSet();

		final int stackInc = 10;
		Object[] stack = new Object[stackInc];
		stack[0] = root;
		int stackLevel = 1;
		int stackSize = stackInc;

		do
		{
			Object newMember;
			try
			{
				while(!family.add(newMember=stack[--stackLevel]));
				assert newMember != null;
				browse(newMember);
			}
			catch(ArrayIndexOutOfBoundsException e)
			{
				break;/*nothing on the stack it is finished*/
			}

			int nbChildren = getNbChildrenReferences(newMember);
			if( nbChildren>0 )
			{
				if( stackSize-stackLevel<nbChildren )
				{
					//we have to increase the stack
					int inc = (nbChildren>stackInc)?nbChildren:stackInc;
					java.lang.System.arraycopy(stack,0,stack=new Object[stackSize+inc],0,stackSize);
					stackSize += stackInc;
				}
				stackLevel = fillArrayWithChildrenReferences(newMember, stack, stackLevel);
			}
		}
		while( stackLevel>0 );//continue while there is some work on the stack

	}


	protected abstract void browse(Object o);


	private static native int getNbChildrenReferences(Object o);
	private static native int fillArrayWithChildrenReferences(Object o,Object[] pool,int offset);
	
}

class ObjectSet
{
	//This class implements A collection that contains no duplicated elements.
	//it contains no pair of elements e1 and e2 such that e1==e2
	
	private static final int SET_INC = 10;
	
	private Object[] set;
	private int size;
	
	
	public ObjectSet()
	{
		set = new Object[SET_INC];
	}
	
	
	public boolean add(@Nullable Object o)
	{
		//return true if o has been added
		//return false if it was already in
		
		//Objects are ordered with their hashcode
		int hashcode;
		try
		{
			hashcode = o.hashCode();
		}
		catch(NullPointerException e)
		{
			return false;
		}
		
		Object[] set = this.set;
		int size = this.size;
		
		int left = 0;
		int right = size-1;
		int middle;
		
		while(left<=right)
		{
			middle = left+((right-left)/2);
			Object current = set[middle];
			if( current!=o )
			{
				int currentHashcode = current.hashCode();
				if(hashcode>currentHashcode) {
					left = middle+1;
				}
				else {
					right = middle-1;
				}
			}
			else {
				return false;//already in the set
			}
		}
		
		//must be inserted at index left
		if( size==set.length )
		{
			//increase the set
			Object[] newSet = new Object[size+SET_INC];
			java.lang.System.arraycopy(set,0,newSet,0,left);
			java.lang.System.arraycopy(set,left,newSet,left+1,size-left);
			set = this.set = newSet;
		}
		else {
			java.lang.System.arraycopy(set,left,set,left+1,size-left);
		}
		
		set[left] = o;
		this.size = size+1;
		return true;
	}
	
}
