@rem BATCH
@rem
@rem Copyright 2020-2025 MicroEJ Corp. All rights reserved.
@rem This library is provided in source code for use, modification and test, subject to license terms.
@rem Any modification of the source code will break MicroEJ Corp. warranties on the whole library.

@ECHO OFF

rem Find java command
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if not %ERRORLEVEL% equ 0 (
	echo.
	echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
	echo.
	echo Please set the JAVA_HOME variable in your environment to match the
	echo location of your Java installation or add the Java command location in your PATH.
	echo.
	echo Press any key to exit
	pause >nul
	exit
)

goto runOnSimulator

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if not exist "%JAVA_EXE%" (
	echo.
	echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
	echo.
	echo Please set the JAVA_HOME variable in your environment to match the
	echo location of your Java installation.
	echo.
	echo Press any key to exit
	pause >nul
	exit
)

:runOnSimulator
echo MicroEJ Virtual Device is being launched. Relax and enjoy
echo:

SET ANT_HOME=%cd%\tools\ant
"%JAVA_EXE%" -cp "vee\tools\ant\lib\*" org.apache.tools.ant.Main -buildfile vee/s3Standalone.microejLaunch