#!/bin/sh
# Copyright 2017-2025 MicroEJ Corp. All rights reserved.
# This library is provided in source code for use, modification and test, subject to license terms.
# Any modification of the source code will break MicroEJ Corp. warranties on the whole library.

exitWithMessage () {
    echo
    echo "$*"
    echo
    read -p "Press Enter to exit" dummy
    exit 1
} >&2

# Find java command
if [ -n "$JAVA_HOME" ] ; then
    JAVACMD=$JAVA_HOME/bin/java
    if [ ! -x "$JAVACMD" ] ; then
        exitWithMessage "ERROR: JAVA_HOME is set to an invalid directory: $JAVA_HOME
Please set the JAVA_HOME variable in your environment to match the location of your Java installation."
    fi
else
    JAVACMD=java
    which java >/dev/null 2>&1 || exitWithMessage "ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.

Please set the JAVA_HOME variable in your environment to match the location of your Java installation or add the Java command location in your PATH."
fi

echo MicroEJ Virtual Device is being launched. Relax and enjoy.

$JAVACMD -cp "vee/tools/ant/lib/*" org.apache.tools.ant.Main -buildfile vee/s3Standalone.microejLaunch