/*
 * Java
 *
 * Copyright 2015-2021 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.kf;

import java.lang.ref.Reference;

import com.is2t.kf.KernelNatives;

import ej.annotation.Nullable;

/*
 * VM known structure
 */
public class Proxy<T> extends Reference<T>{

	public Proxy(){
	}

	public Proxy(T reference) {
		// only for stub
		super(reference);
	}

	protected final native void invoke() throws Throwable;
	protected final native boolean invokeBoolean() throws Throwable;
	protected final native byte invokeByte() throws Throwable;
	protected final native char invokeChar() throws Throwable;
	protected final native short invokeShort() throws Throwable;
	protected final native int invokeInt() throws Throwable;
	protected final native long invokeLong() throws Throwable;

	protected final native float invokeFloat() throws Throwable;
	protected final native double invokeDouble() throws Throwable;
	protected final native Object invokeRef() throws Throwable;

	/*
	 * 2 proxies are equals if they are the same instance or if their target references are equivalent shared interfaces
	 */
	@Override
	public boolean equals(@Nullable Object o) {
		if(this == o){
			return true;
		}

		if (o == null) {
			return false;
		}

		Proxy<?> op;
		try{ op = ((Proxy<?>)o); }
		catch(ClassCastException e){
			return false;
		}

		Kernel.enter();
		Object targetRef = ref;
		Object otherTargetRef = op.ref;

		if(targetRef == null || otherTargetRef == null){
			return false;
		}

		if(targetRef instanceof Class && otherTargetRef instanceof Class){
			return KernelNatives.areEquivalentSharedInterfaces((Class<?>)targetRef, (Class<?>)otherTargetRef);
		}

		return false;
	}

	@Nullable
	public T getReference(){
		Kernel.enter();
		return ref;
	}
}
