/*
 * Java
 *
 * Copyright 2013-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.kf;

import com.is2t.kf.ExceptionWithErrorCode;

import ej.annotation.Nullable;

/**
 * This exception is thrown when a Feature data being loaded has an invalid format.
 * @see Kernel#load(java.io.InputStream)
 */
@SuppressWarnings("serial")
public class InvalidFormatException extends ExceptionWithErrorCode{

	public static final int NO_ELIGIBLE_LOADER 		= 1;
	public static final int LOADER_FORMAT_ERROR 	= 2;
	public static final int CORRUPTED_FO_STREAM = 3;
	public static final int FIRST_SPECIFIC_ERROR = 50; // VM known - see KFDynamicLoaderNativesPool

	public InvalidFormatException(){
		super();
	}

	public InvalidFormatException(int kind){
		super(kind);
	}

	public InvalidFormatException(int kind, @Nullable String message) {
		super(kind, message);
	}
}
