/*
 * Java
 *
 * Copyright 2015-2018 IS2T. All rights reserved
 * IS2T PROPRIETARY/CONFIDENTIAL Use is subject to license terms.
 */
package ej.kf;

import com.is2t.kf.KernelNatives;

/**
 * Inspired by java.util.concurrent.FutureTask<V>
 */
abstract public class AsyncJob implements Runnable {

	private boolean done = false;

	/**
	 * Protected method invoked when this job is done.
	 */
	synchronized protected void done(){
		this.done = true;
		this.notifyAll();
	}

	/**
	 * Waits if necessary for at most the given time for the job to complete.
	 */
	synchronized public void waitJobEnd(long timeout){
		if(!done){
			try {
				this.wait(timeout);
			} catch (InterruptedException e) {
				//nothing to do
			}
		}
	}

	/**
	 * Start this {@link AsyncJob} in a new {@link Thread}.
	 * The created thread is owned by the given feature.
	 * @return true if the job could be started, false if the maximum number of thread is reached
	 */
	public boolean start(Feature feature){
		Thread thread = new Thread(this);

		KernelNatives.setOwner(thread, feature);

		try{ thread.start(); }
		catch(Throwable e){
			return false;
		}
		return true;
	}
}
