/*
 * Java
 *
 * Copyright 2013-2021 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

import ej.kf.Kernel;
import ej.kf.Principal;

/**
 * Objects of this class are generated by SOAR as immutables.
 * <code>WARNING</code>: fields are well known by SOAR.
 */
public class PrincipalData implements Principal {

	public final char[][] fields;

	/* default */ PrincipalData(char[][] fields) {
		this.fields = fields;
	}

	private char[] getField(int field) {
		char[] value = fields[field];
		assert (value != null);
		return value;
	}

	@Override
	public String getValue(int field) {
		return new String(getField(field));
	}

	@Override
	public String toString() {
		String string = toString(new StringBuilder()).toString();
		assert (string != null);
		return string;
	}

	public StringBuilder toString(StringBuilder sb) {
		sb
		.append("CN=").append(getField(FIELD_CN))
		.append(", OU=").append(getField(FIELD_OU))
		.append(", O=").append(getField(FIELD_O))
		.append(", L=").append(getField(FIELD_L))
		.append(", ST=").append(getField(FIELD_ST))
		.append(", C=").append(getField(FIELD_C))
		;
		return sb;
	}
	/**
	 * Returns a clone of the given object. The clone is owned by the kernel.
	 * Executes a deep copy.
	 */
	public static PrincipalData kernelClone(PrincipalData featurePrincipalData) throws CloneNotSupportedException{
		Kernel.enter();

		char[][] originalFields = featurePrincipalData.fields;
		char[][] cloneFields = new char[originalFields.length][];
		for(int i=cloneFields.length ; --i>=0 ; ){
			char[] originalField = originalFields[i];
			assert (originalField != null);
			cloneFields[i] = KernelSupport.kernelCloneArray(originalField);
		}
		return new PrincipalData(cloneFields);
	}

}
