/*
 * Java
 *
 * Copyright 2013-2021 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

import ej.kf.Kernel;


/**
 * Object of this class represent Kernel/Feature data (generated by SOAR as immutables).
 * <code>WARNING</code>: fields are well known by SOAR.
 */
public class ModuleData {
	// == VM Known fields
	public final char[] name;
	public final char[] version;
	public final PrincipalData owner;
	public final byte[] uid;
	// == VM Known fields

	/* default */ ModuleData(char[] name, char[] version, PrincipalData owner, byte[] uid) {
		this.name = name;
		this.version = version;
		this.owner = owner;
		this.uid = uid;
	}

	/**
	 * Returns a clone of the given object. The clone is owned by the kernel.
	 * Executes a deep copy.
	 */
	public static ModuleData kernelClone(ModuleData featureData) {
		Kernel.enter();

		try {
			char[] name = KernelSupport.kernelCloneArray(featureData.name);
			char[] version = KernelSupport.kernelCloneArray(featureData.version);
			PrincipalData owner = PrincipalData.kernelClone(featureData.owner);
			byte[] uid = KernelSupport.kernelCloneArray(featureData.uid);
			return new ModuleData(name, version, owner, uid);
		} catch (CloneNotSupportedException e) {
			throw new RuntimeException(e);
		}
	}

}
