/*
 * Java
 *
 * Copyright 2013-2021 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

import ej.kf.Feature;
import ej.kf.Kernel;

public class KernelSupport {

	/**
	 * Internal API called by the VM when an exception of a Feature has not been caught.
	 * This method is called from Feature context owner.
	 * The handler is called in Kernel mode.
	 */
	public static void uncaughtException(Throwable e) {
		Feature f = Kernel.getContextOwnerFeature();
		assert f != null;
		uncaughtException(f, e);
	}

	/**
	 * The handler is called in Kernel mode.
	 */
	public static void uncaughtException(Feature f, Throwable e) {
		Kernel.enter();
		Thread t = Thread.currentThread();
		assert (t != null);
		Kernel.handler.uncaughtException(f, t, e);
	}

	/**
	 * Returns a clone of the given array. The clone is owned by the kernel.
	 */
	public static char[] kernelCloneArray(char[] featureArray){
		Kernel.enter();
		char[] clone = new char[featureArray.length];
		System.arraycopy(featureArray, 0, clone, 0, clone.length);
		return clone;
	}

	/**
	 * Returns a clone of the given array. The clone is owned by the kernel.
	 */
	public static byte[] kernelCloneArray(byte[] featureArray){
		Kernel.enter();
		byte[] clone = new byte[featureArray.length];
		System.arraycopy(featureArray, 0, clone, 0, clone.length);
		return clone;
	}
}
