/*
 * Java
 *
 * Copyright 2013-2022 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

import java.io.IOException;
import java.io.InputStream;

import ej.kf.AlreadyLoadedFeatureException;
import ej.kf.Feature;
import ej.kf.IncompatibleFeatureException;
import ej.kf.InvalidFormatException;
import ej.kf.Kernel;

/**
 * Feature loader interface.
 * Method {@link #load(byte[], InputStream)} is called synchronously.
 */
public interface IFeatureLoader {

	/**
	 * Tell whether this loader can load from the first 4 bytes signature
	 * @param signature 4 bytes array
	 */
	public boolean canLoad(byte[] signature);

	/**
	 * Tell whether this loader can unload a feature
	 */
	public boolean canUnload();

	/**
	 * Load Feature from an {@link InputStream} without the 4 bytes signature.
	 */
	public Feature load(byte[] signature, InputStream is)
			throws IOException, InvalidFormatException, IncompatibleFeatureException, AlreadyLoadedFeatureException;

	/**
	 * Unload the code of the given feature.<br>
	 * This method assumes there is no more references to objects or code of the given feature.<p>
	 * The given feature must be in the INSTALLED state.
	 *
	 * @return true if success, false otherwise.
	 */
	public boolean unload(Feature f);

	/**
	 * Load and populate already installed Features.
	 *
	 * @see Kernel#addInstalledFeature(Feature)
	 */
	public void loadInstalledFeatures()
			throws InvalidFormatException, IncompatibleFeatureException, AlreadyLoadedFeatureException;
}
